/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// imageconfig.cpp

#include "imageconfig.h"
#include "image.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qcheckbox.h>

#include <kurlrequester.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kurl.h>



ImageConfig::ImageConfig(KoverArtist::Image* aImage, QWidget* aParent)
:Inherited(aParent)
,mImage(aImage)
{
   QWidget *base = this;
   QHBoxLayout *box = 0;
   QLabel *lbl;

   QVBoxLayout *vbox = new QVBoxLayout(base);

   mEdtFileName = new KUrlRequester(base);
   mEdtFileName->setMinimumHeight(mEdtFileName->sizeHint().height());
//    mEdtFileName->setShowLocalProtocol(false);
   vbox->addWidget(mEdtFileName, Qt::AlignLeft);
   KFileDialog *fdlg = mEdtFileName->fileDialog();
   fdlg->setFilter(QString("*.png *.jpg *.gif *.xpm *.bmp *.pbm *.ppm|%1\n*|%2")
      .arg(i18n("Image Files")).arg(i18n("All Files"))
      );
   connect(mEdtFileName, SIGNAL(urlSelected(const QString&)),
           this, SLOT(setFileName(const QString&)));
   connect(mEdtFileName, SIGNAL(returnPressed(const QString&)),
           this, SLOT(setFileName(const QString&)));


   box = new QHBoxLayout();
   vbox->addLayout(box);
   lbl = new QLabel(i18n("Position")+":", base);
   lbl->setFixedSize(lbl->sizeHint());
   box->addWidget(lbl);

   mCboPosition = new QComboBox(base);
   mCboPosition->addItem(i18n("Centered"));
   mCboPosition->addItem(i18n("Tiled"));
   mCboPosition->addItem(i18n("Centered Tiled"));
   mCboPosition->addItem(i18n("Centered Maxpect"));
   mCboPosition->addItem(i18n("Scaled"));
   mCboPosition->addItem(i18n("Scale & Crop"));
   mCboPosition->setMinimumSize(mCboPosition->sizeHint());
   connect(mCboPosition, SIGNAL(activated(int)), this, SLOT(setPosition(int)));
   box->addWidget(mCboPosition, Qt::AlignLeft);


   mCbxOnSides = new QCheckBox(i18n("Image covers sides"), base);
   mCbxOnSides->setFixedSize(mCbxOnSides->sizeHint());
   connect(mCbxOnSides, SIGNAL(toggled(bool)), this, SLOT(setOnSides(bool)));
   vbox->addWidget(mCbxOnSides, Qt::AlignLeft);


   vbox->activate();
   update();
}


ImageConfig::~ImageConfig()
{
}


void ImageConfig::update()
{
   bool upd = updatesEnabled();
   setUpdatesEnabled(false);

//    mEdtFileName->setUrl(mImage->url().prettyURL());
   mEdtFileName->setUrl(mImage->url());
   mCboPosition->setCurrentIndex(int(mImage->position()));
   mCbxOnSides->setChecked(mImage->onSides());

   setUpdatesEnabled(upd);
}


void ImageConfig::setFileName(const QString& aFileName)
{
//    if (aFileName==mImage->url().prettyURL()) return;
   if (aFileName==mImage->url()) return;
//    mImage->load(KUrl::fromPathOrUrl(aFileName));
   mImage->load(aFileName);
   if (updatesEnabled()) emit changed();
}


void ImageConfig::setPosition(int aIdx)
{
   mImage->setPosition((KoverArtist::ImagePosition)aIdx);
   if (updatesEnabled()) emit changed();
}


void ImageConfig::setOnSides(bool aOnSides)
{
   if (aOnSides==mImage->onSides()) return;
   mImage->setOnSides(aOnSides);
   if (updatesEnabled()) emit changed();
}
