/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* effect.h
 */
#ifndef effect_h
#define effect_h

#include <qcolor.h>

class QDomElement;
class QDomDocument;


namespace KoverArtist
{
/** A effect description.
 */
class Effect
{
public:
   /** All known effect types. */
   // If you change something here, do not forget to change the string
   // constants in project.cpp !
   enum Type { NONE=0, OUTLINE, GLOW, SHADOW, BOX, ROUNDED_BOX, _NUM_TYPES };

   Effect();
   Effect(Type t, const QColor& color1=QColor("#cccccc"), const QColor& color2=Qt::white,
          int size=8, int transparency=192);
   Effect(const Effect& o);
   Effect& operator=(const Effect& o);

   /** Clear the object. */
   void clear();

   /** Effect type. */
   Type type() const { return mType; }
   void setType(Type t) { mType = t; }

   /** Effect color 1. */
   const QColor& color1() const { return mColor1; }
   void setColor1(const QColor& c) { mColor1 = c; }

   /** Effect color 2. */
   const QColor& color2() const { return mColor2; }
   void setColor2(const QColor& c) { mColor2 = c; }

   /** Effect transparency 0..100% */
   int transparency() const { return mTransparency; }
   void setTransparency(int t) { mTransparency = t; }

   /** Relative effect size 0..100% */
   int size() const { return mSize; }
   void setSize(int s) { mSize = s; }

   /** Returns the effect type as string. */
   const char* typeString() const { return typeString(mType); }

   /** Returns the effect type t as string. */
   static const char* typeString(Type t);

   /** Translates the string str to effect type. */
   static Type typeFromString(const char* str);

   /** Fill the DOM element de with the object's contents. */
   void toDom(QDomDocument& doc, QDomElement& de) const;

   /** Set the object from the DOM element de. */
   bool fromDom(const QDomElement& de);

protected:
   Type mType;
   QColor mColor1, mColor2;
   int mTransparency, mSize;
};

} //namespace KoverArtist

#endif /*effect_h*/
