/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cddbchooser.h"

// #include <qheader.h>
#include <qlabel.h>
#include <qlayout.h>
#include <QListView>
#include <QModelIndex>
#include <QStringListModel>
#include <QVBoxLayout>



CddbChooser::CddbChooser(const QStringList& aValues, const QString& aCaption,
                         const QString& aDescription, QWidget* aParent)
:Inherited(aParent)
{
   QWidget *base = new QWidget(this);
   QVBoxLayout *box = new QVBoxLayout(base);

   setModal(true);
   setWindowTitle(aCaption);
   setButtons( KDialog::Ok | KDialog::Cancel);
   setMainWidget(base);

   QLabel *lbl = new QLabel(aDescription, base);
   lbl->setFixedSize(lbl->sizeHint());
   box->addWidget(lbl);

   mLstValues = new QListView(base);
   box->addWidget(mLstValues);
   connect(mLstValues, SIGNAL(doubleClicked(const QModelIndex&)),
           this, SLOT(listItemActivated(const QModelIndex&)));

   QAbstractItemModel *model = new QStringListModel(aValues, this);
   mLstValues->setModel(model);

//    resize(400,300);
   resize(sizeHint());
}


void CddbChooser::listItemActivated(const QModelIndex&)
{
   accept();
}


QString CddbChooser::currentItem() const
{
   const QItemSelectionModel *sel = mLstValues->selectionModel();
   if (!sel->hasSelection()) return QString::null;

   return mLstValues->model()->data(sel->selectedIndexes().first(), Qt::DisplayRole).toString();
}
