/* 
 *  Xfmedia Remote Plugin - Xfmedia Remote Control Plugin for Xfce4 Panel
 *  Copyright (C) 2005  Pasi Orovuo <pasi.ov@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef XFMEDIA_REMOTE_H_INCLUDED
#define XFMEDIA_REMOTE_H_INCLUDED

#include <gtk/gtk.h>

typedef struct _XfmediaRemote   XfmediaRemote;

/* Work around some dbus sillyness */
void xfmedia_remote_disconnect( void );

XfmediaRemote *xfmedia_remote_new( guint );
void xfmedia_remote_free( XfmediaRemote * );
gboolean xfmedia_remote_xfmedia_is_running( XfmediaRemote * );

gboolean xfmedia_remote_song_previous( XfmediaRemote * );
gboolean xfmedia_remote_song_play( XfmediaRemote *, gint );
gboolean xfmedia_remote_song_pause( XfmediaRemote * );
gboolean xfmedia_remote_song_stop( XfmediaRemote * );
gboolean xfmedia_remote_song_next( XfmediaRemote * );
gboolean xfmedia_remote_quit( XfmediaRemote * );

gboolean xfmedia_remote_playlist_add_file( XfmediaRemote *, const gchar *, gint );
gboolean xfmedia_remote_playlist_remove_file( XfmediaRemote *, guint );
gboolean xfmedia_remote_playlist_load( XfmediaRemote *, const gchar * );
gboolean xfmedia_remote_playlist_save( XfmediaRemote *, const gchar * );
gboolean xfmedia_remote_playlist_clear( XfmediaRemote * );
gboolean xfmedia_remote_playlist_get( XfmediaRemote *, gchar ***, guint * );
/* gboolean xfmedia_remote_playlist_entry_get( XfmediaRemote *, guint, gchar ** ); */
gboolean xfmedia_remote_now_playing( XfmediaRemote *, gint *, gchar **, guint * );

#endif

