/* arch specific bits */
#ifdef __x86_64__
# define longmode  1
# define ureg_t    uint64_t
# define sreg_t    int64_t
struct regs {
    uint64_t rax;
    uint64_t rbx;
    uint64_t rcx;
    uint64_t rdx;
    uint64_t r8;
    uint64_t r9;
    uint64_t r10;
    uint64_t r11;
    uint64_t r12;
    uint64_t r13;
    uint64_t r14;
    uint64_t r15;
    uint64_t rsi;
    uint64_t rdi;
    uint64_t rbp;
};
#else
# define longmode  0
# define ureg_t    uint32_t
# define sreg_t    int32_t
struct regs {
    uint32_t rax;
    uint32_t rbx;
    uint32_t rcx;
    uint32_t rdx;
    uint32_t rsi;
    uint32_t rdi;
    uint32_t rbp;
};
#endif

#define asmlinkage __attribute__((regparm(0)))

asmlinkage void do_hypercall(struct regs *regs);

static inline void outb(uint8_t value, uint16_t port)
{
    asm volatile("outb %[value],%w[port]"
		 : /* no output */
		 : [value] "a" (value), [port] "Nd" (port)
		 : "memory");
}
