#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <inttypes.h>
#include <errno.h>
#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>

#include <xenctrl.h>

#include "xennerctrl.h"
#include "evtchnd.h"
#include "xenner.h"

int evtchn_port(struct xenvm *xen, char *name)
{
    int port;

    if (-1 == xen->evtchnd) {
	/* fake ports */
	xen->next_event++;
	port = xen->next_event;
    } else {
	port = xc_evtchn_bind_unbound_port(xen->evtchnd, 0);
    }
    d2printf("%s: port %d is %s\n", __FUNCTION__, port, name);
    return port;
}

int evtchn_notify(struct xenvm *xen, int port)
{
    if (-1 == xen->evtchnd)
	return 0;
    return xc_evtchn_notify(xen->evtchnd, port);
}

int evtchn_close(struct xenvm *xen, int port)
{
    if (-1 == xen->evtchnd)
	return 0;
    return xc_evtchn_unbind(xen->evtchnd, port);
}

static int has_data(int fd)
{
    struct timeval tv;
    fd_set rd;
    int rc;

    for (;;) {
	FD_ZERO(&rd);
	FD_SET(fd,&rd);
	tv.tv_sec  = 0;
	tv.tv_usec = 0;
	rc = select(fd+1, &rd, NULL, NULL, &tv);
	if (rc != -1 || errno != EINTR)
	    break;
    }
    return rc;
}

static int evtchn_data(struct xenvm *xen, int fd, void *data)
{
    static int errors = 0;
    int count = 0;
    int port;

    if (-1 == xen->evtchnd)
	return 0;

    for (;;) {
	if (!has_data(xen->evtchnd))
	    return count;
	port = xc_evtchn_pending(xen->evtchnd);
	if (port >= 0) {
	    if (port == xen->console_event)
		d3printf("%s: %d pending (console)\n", __FUNCTION__, port);
	    else if (port == xen->xenstore_event)
		d3printf("%s: %d pending (xenstore)\n", __FUNCTION__, port);
	    else
		d2printf("%s: %d pending\n", __FUNCTION__, port);
	    raise_event(xen->vcpu + 0 /* FIXME */, port);
	    errors = 0;
	    count++;
	} else if (++errors > 3) {
	    d0printf("%s: repeated evtchn failure, closing\n", __FUNCTION__);
	    evtchn_fini(xen);
	    return count;
	}
    }
    return count;
}

int evtchn_init(struct xenvm *xen)
{
    if (xen->debug)
	libxc_fixme = 1;
    if (xen->debug > 1 && !xen->nostderr)
	libxc_trace = 1;

    xen->evtchnd = xc_evtchn_open();
    if (-1 == xen->evtchnd) {
	d0printf("%s: can't connect to evtchnd (not running?)\n", __FUNCTION__);
	return -1;
    }

    xenner_register_cb(xen, "evtchn", xen->evtchnd, NULL, evtchn_data);
    xenner_evtchnd_domid(xen->evtchnd, xen->domid);
    return 0;
}

void evtchn_fini(struct xenvm *xen)
{
    if (-1 != xen->evtchnd)
	xc_evtchn_close(xen->evtchnd);
    xen->evtchnd = -1;
}
