[comment {-*- tcl -*- doctools manpage}]
[manpage_begin term::ansi::code::macros n 0.1]
[copyright {2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Terminal control}]
[titledesc {Macro sequences}]
[require Tcl 8.4]
[require textutil::repeat]
[require textutil::tabify]
[require term::ansi::code::macros [opt 0.1]]
[description]

This package provides higher level control sequences for more complex
shapes.

[section API]
[subsection Introspection]

[list_begin definitions]
[call [cmd ::term::ansi::code::macros::names]]

This command is for introspection. It returns as its result a list
containing the names of all attribute commands.

[call [cmd ::term::ansi::code::macros::import] [opt [arg ns]] [opt [arg arg]...]]

This command imports some or all attribute commands into the namespace
[arg ns]. This is by default the namespace [emph macros]. Note that
this is relative namespace name, placing the imported command into a
child of the current namespace. By default all commands are imported,
this can howver be restricted by listing the names of the wanted
commands after the namespace argument.

[list_end]

[subsection Sequences]
[list_begin definitions]

[call [cmd ::term::ansi::code::macros::menu] [arg menu]]

The description of a menu is converted into a formatted rectangular
block of text, with the menu command characters highlighted using bold
red text.  The result is returned as the result of the command.

[para]

The description, [arg menu], is a dictionary mapping from menu label
to command character.


[call [cmd ::term::ansi::code::macros::frame] [arg string]]

The paragraph of text contained in the string is padded with spaces at
the right margin, after normalizing internal tabs, and then put into a
frame made of box-graphics. The result is returned as the result of
the command.

[list_end]
[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph term] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords ansi terminal control menu frame]
[manpage_end]
