[comment {-*- tcl -*- doctools manpage}]
[manpage_begin ftp::geturl n 0.2.1]
[moddesc   {ftp client}]
[titledesc {Uri handler for ftp urls}]
[require Tcl 8.2]
[require ftp::geturl [opt 0.2.1]]
[description]

This package provides a command which wraps around the client side of
the [term ftp] protocol provided by package [package ftp] to allow the
retrieval of urls using the [term ftp] schema.

[section API]

[list_begin definitions]
[call [cmd ::ftp::geturl] [arg url]]

This command can be used by the generic command [cmd ::uri::geturl]
(See package [package uri]) to retrieve the contents of ftp
urls. Internally it uses the commands of the package [package ftp] to
fulfill the request.

[para]

The contents of a [term ftp] url are defined as follows:

[list_begin definitions]

[def [term file]]

The contents of the specified file itself.

[def [term directory]]

A listing of the contents of the directory in key value notation where
the file name is the key and its attributes the associated value.

[def [term link]]

The attributes of the link, including the path it refers to.

[list_end]
[list_end]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph ftp] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[see_also ftpd smtp pop3 mime]
[keywords ftp {rfc 959} internet net]
[manpage_end]
