/***************************************************************************
    smb4ksudowriterinterface  -  This class provides an interface to the
    smb4k_sudowriter utility program that writes entries to the sudoers
    file.
                             -------------------
    begin                : Sa Aug 2 2008
    copyright            : (C) 2008 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSUDOWRITERINTERFACE_H
#define SMB4KSUDOWRITERINTERFACE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <QObject>

// KDE includes
#include <kdemacros.h>
#include <kprocess.h>


/**
 * This class provides an interface to the smb4k_sudowriter utility program
 * that writes to the sudoers file.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class KDE_EXPORT Smb4KSudoWriterInterface : public QObject
{
  Q_OBJECT

  friend class Smb4KSudoWriterInterfacePrivate;

  public:
    /**
     * Enumeration for the operation that is currently done.
     */
    enum Operation { AddUser,
                     RemoveUser,
                     Unknown };

    /**
     * This function returns a static pointer to this class.
     *
     * @returns a static pointer to the Smb4KSudoWriterInterface class.
     */
    static Smb4KSudoWriterInterface *self();

    /**
     * This function adds the name of the current user to the Smb4K section
     * in the sudoers file by invoking the smb4k_sudowriter utility program.
     * If no Smb4K section exists, the utility program will create one.
     */
    void addUser();

    /**
     * This function removes the name of the current user from the Smb4K
     * section in the sudoers file by invoking the smb4k_sudowriter utility
     * program. If the user is the only entry, the Smb4K section will be
     * removed from the sudoers file.
     */
    void removeUser();

  signals:
    /**
     * This signal is emitted when somthing went wrong with the writing to
     * the sudoers file.
     */
    void failed( Smb4KSudoWriterInterface::Operation operation );

    /**
     * This signal is emitted when the writing to the sudoers file has
     * finished. It is emitted in case the writing was successful as well
     * as in case it wasn't.
     */
    void finished( Smb4KSudoWriterInterface::Operation operation );

  protected slots:
    /**
     * This slot is called, when the process exited.
     *
     * @param exitCode           The exit code of the process
     *
     * @param exitStatus         The exit status of the process (@see QProcess::ExitStatus)
     */
    void slotProcessFinished( int exitCode, QProcess::ExitStatus exitStatus );

    /**
     * This slot is invoked when an error occurred with the process.
     *
     * @param errorCode          The error code returned by the process
     */
    void slotProcessError( QProcess::ProcessError errorCode );

  private:
    /**
     * The constructor.
     */
    Smb4KSudoWriterInterface();

    /**
     * The destructor.
     */
    ~Smb4KSudoWriterInterface();

    /**
     * Operation
     */
    Operation m_operation;

    /**
     * The KProcess object
     */
    KProcess *m_proc;

    /**
     * Process error
     */
    QProcess::ProcessError m_process_error;
};

#endif
