/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for monthly report.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgmonthlyboardwidget.h"
#include "skgmonthlypluginwidget.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"

#include <QDomDocument>

SKGMonthlyBoardWidget::SKGMonthlyBoardWidget ( SKGDocument* iDocument )
        : SKGWidget ( iDocument ), mode(0)
{
    SKGTRACEIN ( 10, "SKGMonthlyBoardWidget::SKGMonthlyBoardWidget" );

    ui.setupUi ( this );

    onModified();

    //Refresh
    connect ( ( const QObject* ) getDocument(), SIGNAL ( transactionSuccessfullyEnded ( int ) ), this, SLOT ( onModified() ), Qt::QueuedConnection );
}

SKGMonthlyBoardWidget::~SKGMonthlyBoardWidget()
{
    SKGTRACEIN ( 10, "SKGMonthlyBoardWidget::~SKGMonthlyBoardWidget" );
}

QString SKGMonthlyBoardWidget::getState()
{
    SKGTRACEIN ( 10, "SKGMonthlyBoardWidget::getState" );
    QDomDocument doc ( "SKGML" );
    QDomElement root = doc.createElement ( "parameters" );
    doc.appendChild ( root );

    //Get state
    root.setAttribute ( "mode", SKGServices::intToString(mode) );

    return doc.toString();
}

void SKGMonthlyBoardWidget::setState ( const QString& iState )
{
    SKGTRACEIN ( 10, "SKGMonthlyBoardWidget::setState" );
    QDomDocument doc ( "SKGML" );
    doc.setContent ( iState );
    QDomElement root = doc.documentElement();

    //Set state
    QString modeS=root.attribute ( "mode" );
    if ( !modeS.isEmpty() ) mode=SKGServices::stringToInt(modeS);

    onModified ();
}

void SKGMonthlyBoardWidget::onModified ()
{
    QDate month=QDate::currentDate();
    month=month.addDays(-month.day()+1).addMonths(-1);

    QDate previousMonth=month.addMonths(-1);

    if (mode==0) ui.kText->setText(SKGMonthlyPluginWidget::get5MainCategories(static_cast<SKGDocumentBank*>(getDocument()), month.toString("yyyy-MM"), false));
    else if (mode==1) ui.kText->setText(SKGMonthlyPluginWidget::get5MainCategoriesVariation(static_cast<SKGDocumentBank*>(getDocument()), month.toString("yyyy-MM"), previousMonth.toString("yyyy-MM")));
}

#include "skgmonthlyboardwidget.moc"
