/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgservices.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    //Init test
    SKGINITTEST(true);

    //============================================================================
    {
        //Test bank document
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGBankObject bank(&document1);
        SKGAccountObject account;
        SKGUnitObject unit_euro(&document1);
        SKGUnitValueObject unit_euro_val1;
        QDate d1=QDate::currentDate().addMonths(-6);
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "BANK_T1", err);

            //Creation bank
            SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
            SKGTESTERROR("BANK:save", bank.save(), true);

            //Creation account
            SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
            SKGTESTERROR("ACCOUNT:setName",account.setName("Courant steph"), true);
            SKGTESTERROR("ACCOUNT:save",account.save(), true);

            //Creation unit
            SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
            SKGTESTERROR("UNIT:save", unit_euro.save(), true);

            //Creation unitvalue
            SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
            SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
            SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(d1), true);
            SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

            //Creation operation
            SKGOperationObject op;
            SKGTESTERROR("ACCOUNT:addOperation",account.addOperation(op), true);
            SKGTESTERROR("OPE:setMode",op.setMode("cheque"), true);
            SKGTESTERROR("OPE:setDate",op.setDate(d1), true);
            SKGTESTERROR("OPE:setUnit",op.setUnit(unit_euro), true);
            SKGTESTERROR("OPE:save", op.save(), true);

            SKGPayeeObject payee(&document1);
            SKGPayeeObject payeeCopy(payee);
            SKGPayeeObject payeeCopy2((SKGObjectBase) payee);
            SKGTESTERROR("REF:setName",payee.setName("payee"), true);
            SKGTESTERROR("REF:setAddress",payee.setAddress("address"), true);
            SKGTESTERROR("REF:save", payee.save(), true);
            SKGTEST("REF:getName", payee.getName(), "payee");
            SKGTEST("REF:getAddress", payee.getAddress(), "address");

            SKGTESTERROR("OPE:setPayee",op.setPayee(payee), true);
            SKGTESTERROR("OPE:save", op.save(), true);
            SKGPayeeObject payee2;
            SKGTESTERROR("OPE:getPayee",op.getPayee(payee2), true);
            SKGTEST("OPE:compare", (payee==payee2), true);

            SKGTESTERROR("REF:load", payee.load(), true);
            SKGTEST("REF:getCurrentAmount", payee.getCurrentAmount(), 0);

            SKGPayeeObject pay;
            SKGTESTERROR("REF:createPayee",SKGPayeeObject::createPayee ( &document1, "pay", pay, true ), true);
        }
    }

    //End test
    SKGENDTEST();
}
