/***************************************************************************
 *   Copyleft (C) 2004 by Cocophotos                                       *
 *   cocophotos@hotmail.com                                                *
 *   Sous licence GPL v2 ou plus                                           *
 ***************************************************************************/

#include "ftpsignet.h"
#include "scythia.h"

extern scythia *mw;		// Pointeur qui permet de récupérer l'objet
// principal de la classe ListeSignet

ftpSignet::ftpSignet(QWidget * parent):QDialog(parent)
{
	setupUi(this);
	connect(identifiant, SIGNAL(textChanged(const QString &)), this,
	        SLOT(slotSDataChanged(const QString &)));
	connect(password, SIGNAL(textChanged(const QString &)), this,
	        SLOT(slotSDataChanged(const QString &)));
	connect(username, SIGNAL(textChanged(const QString &)), this,
	        SLOT(slotSDataChanged(const QString &)));
	connect(deleteButton, SIGNAL(clicked()), this, SLOT(slotDeleteSignet()));
	connect(signetList, SIGNAL(itemClicked(QListWidgetItem *)), this,
	        SLOT(slotClickedIdentifiant()));
	connect(saveButton, SIGNAL(clicked()), this, SLOT(slotSSave()));
	connect(modifButton, SIGNAL(clicked()), this, SLOT(slotModifSignet()));

	int max = mw->list.NbItem();
	for (int i = 0; i < max; i++)
		signetList->addItem(mw->list.RecupIdentifiant(i));

	// On arrange un peu le splitter en diminuant la taille de la partie de gauche
	splitter->setStretchFactor(1, 2);
}

/***************Fonction associé à la modification d'un signet****************/
void ftpSignet::slotModifSignet()
{
	if ((itemSignet = signetList->currentRow()) == -1)	// Item cliqué dans la liste
		return;

	QString mode;
	if (transferMode->currentText() == tr("Passif"))
		mode = "Passif";
	else
		mode = "Actif";

	if (sGuardPassword->isChecked())	// Si la mémorisation du mot de passe est coché, on le sauvegarde
		mw->list.ModifItem(itemSignet, identifiant->text().toLocal8Bit(),
		                   username->text().toLocal8Bit(),
		                   host->currentText().toLocal8Bit(),
		                   password->text().toLocal8Bit(), port->value(),
		                   mode.toLocal8Bit(), proxyName->text().toLocal8Bit(),
		                   proxyPort->value());
	else			// Sinon on laisse le password vide
		mw->list.ModifItem(itemSignet, identifiant->text().toLocal8Bit(),
		                   username->text().toLocal8Bit(),
		                   host->currentText().toLocal8Bit(), "", port->value(),
		                   mode.toLocal8Bit(), proxyName->text().toLocal8Bit(),
		                   proxyPort->value());

	// Change l'identifiant dans la liste
	signetList->currentItem()->setText(identifiant->text());
}

/*************Slot pour récupérer le texte du fichier Scythia-signets lorsque l'on clique dans la liste**********/
void ftpSignet::slotClickedIdentifiant()
{
	if ((itemSignet = signetList->currentRow()) == -1)
	{
		identifiant->setText("");
		host->setEditText("");
		username->setText("");
		password->setText("");
		port->setValue(25);
		transferMode->setCurrentIndex(0);
		proxyName->setText("");
		proxyPort->setValue(0);

		return;
	}

	identifiant->setText(mw->list.RecupIdentifiant(itemSignet));	// Récup de l'identifiant
	username->setText(mw->list.RecupLogin(itemSignet));	// Récup du nom d'utilisateur
	password->setText(mw->list.RecupMotDePasse(itemSignet));	// Récup du mot de passe
	host->setEditText(mw->list.RecupHote(itemSignet));	// Recup de l'hote
	port->setValue(mw->list.RecupPort(itemSignet));	// Recup du port
	if (mw->list.RecupTransferMode(itemSignet) == "Passif")
		transferMode->setCurrentIndex(0);
	else
		transferMode->setCurrentIndex(1);
	proxyName->setText(mw->list.RecupProxyName(itemSignet));
	proxyPort->setValue(mw->list.RecupProxyPort(itemSignet));
}

/***************Slot pour effacer un signet***************************/
void ftpSignet::slotDeleteSignet()
{
	// Si l'item sélectionné doit bien être supprimé
	if ((itemSignet = signetList->currentRow()) == -1
	        || QMessageBox::information(NULL, tr("Confirmation"),
	                                    trUtf8
	                                    ("Voulez-vous réellement effacer le signet \"")
	                                    + signetList->currentItem()->text() +
	                                    "\"", "&Oui", "&Non", QString::null, 0, 1) == 1)
		return;

	signetList->takeItem(itemSignet);	// On supprime l'item de la listBox
	mw->list.Supprimer(itemSignet);	// On supprime le groupe correspondant dans le fichier Scythia-signets

	slotClickedIdentifiant();
}

void ftpSignet::slotSSave()
{
	QString transfer;
	if (transferMode->currentText() == tr("Passif"))
		transfer = "Passif";
	else
		transfer = "Actif";

	if (sGuardPassword->isChecked())
		mw->list.Ajouter(identifiant->text(),
		                 username->text(),
		                 host->currentText(),
		                 password->text(), port->value(),
		                 transfer, proxyName->text(), proxyPort->value());
	else
		mw->list.Ajouter(identifiant->text(),
		                 username->text(),
		                 host->currentText(), "", port->value(),
		                 transfer, proxyName->text(), proxyPort->value());

	signetList->clear();

	int max = mw->list.NbItem();
	for (int i = 0; i < max; i++)
		signetList->addItem(mw->list.RecupIdentifiant(i));
}

void ftpSignet::slotSDataChanged(const QString &)
{
	if (!identifiant->text().isEmpty() && !host->currentText().isEmpty()
	        && !username->text().isEmpty())
	{
		saveButton->setEnabled(TRUE);
		modifButton->setEnabled(TRUE);
		deleteButton->setEnabled(TRUE);
	}
	else
	{
		saveButton->setEnabled(FALSE);
		modifButton->setEnabled(FALSE);
		deleteButton->setEnabled(FALSE);
	}
}
