TEMPLATE	= app
LANGUAGE	= C++

CONFIG	+= release warn_on thread qt
QT += network

HEADERS	+= ./src/scythia.h \
	./src/liste_signet.h \
	./src/ftpsignet.h \
	./src/aide.h \
	./src/ftpconnect.h \
	./src/choose_prog.h \
	./src/transfers.h \
	./src/BasicDialog/basicdialog.h \
	./src/MyFtp/mydd.h \
	./src/MyFtp/myftp.h \
	./src/MyFtp/myftptransfercontrol.h \
	./src/MyFtp/mytreewidget.h \
	./src/MyFtp/BasicTreeWidget/basictreewidget.h

SOURCES	+= ./src/main.cpp \
	./src/scythia.cpp \
	./src/liste_signet.cpp \
	./src/ftpsignet.cpp \
	./src/ftpconnect.cpp \
	./src/choose_prog.cpp \
	./src/transfers.cpp \
	./src/BasicDialog/basicdialog.cpp \
	./src/MyFtp/mydd.cpp \
	./src/MyFtp/myftp.cpp \
	./src/MyFtp/myftptransfercontrol.cpp \
	./src/MyFtp/mytreewidget.cpp \
	./src/MyFtp/BasicTreeWidget/basictreewidget.cpp

win32: {
LIBS+= -lgdi32
RC_FILE = ./src/scythia_icon.rc
}

RESOURCES = ./src/scythia.qrc \
	./src/MyFtp/myftp.qrc \
	./src/BasicDialog/basicdialog.qrc

FORMS	= ./src/scythia.ui \
	./src/ftpsignet.ui \
	./src/ftpconnect.ui \
	./src/aide.ui \
	./src/choose_prog.ui \
	./src/transfers.ui \

TARGET = ./bin/scythia

unix:lang.path = /usr/share/scythia/lang/
unix:lang.files = ./translations/*.qm

unix:icon.path = /usr/share/pixmaps/
unix:icon.files = ./src/pixmaps/scythia.xpm

unix:icon2.path = /usr/share/icons/hicolor/128x128/apps/
unix:icon2.files = ./src/pixmaps/scythia.png

unix:desktop.path = /usr/share/applnk/Internet/
unix:desktop.files = ./src/scythia.desktop

unix:doc.path = /usr/share/doc/scythia/html/
unix:doc.files = ./doc/html/*

unix:target.path = /usr/bin

unix:!mac {
	INSTALLS = lang icon icon2 desktop doc target
}

!win32: {
UI_DIR = ./build/ui
MOC_DIR = ./build/moc
OBJECTS_DIR = ./build/obj
RCC_DIR = ./build/rcc
}

TRANSLATIONS += ./translations/english.ts \
				./translations/russian.ts \
				./translations/polish.ts

