/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_msgsvc.h"

static bool api_NetrMessageNameAdd(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct NetrMessageNameAdd *r;

	call = &ndr_table_msgsvc.calls[NDR_NETRMESSAGENAMEADD];

	r = talloc(talloc_tos(), struct NetrMessageNameAdd);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NetrMessageNameAdd, r);
	}

	_NetrMessageNameAdd(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NetrMessageNameAdd, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_NetrMessageNameEnum(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct NetrMessageNameEnum *r;

	call = &ndr_table_msgsvc.calls[NDR_NETRMESSAGENAMEENUM];

	r = talloc(talloc_tos(), struct NetrMessageNameEnum);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NetrMessageNameEnum, r);
	}

	_NetrMessageNameEnum(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NetrMessageNameEnum, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_NetrMessageNameGetInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct NetrMessageNameGetInfo *r;

	call = &ndr_table_msgsvc.calls[NDR_NETRMESSAGENAMEGETINFO];

	r = talloc(talloc_tos(), struct NetrMessageNameGetInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NetrMessageNameGetInfo, r);
	}

	_NetrMessageNameGetInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NetrMessageNameGetInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_NetrMessageNameDel(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct NetrMessageNameDel *r;

	call = &ndr_table_msgsvc.calls[NDR_NETRMESSAGENAMEDEL];

	r = talloc(talloc_tos(), struct NetrMessageNameDel);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NetrMessageNameDel, r);
	}

	_NetrMessageNameDel(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NetrMessageNameDel, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_msgsvc_cmds[] = 
{
	{"NETRMESSAGENAMEADD", NDR_NETRMESSAGENAMEADD, api_NetrMessageNameAdd},
	{"NETRMESSAGENAMEENUM", NDR_NETRMESSAGENAMEENUM, api_NetrMessageNameEnum},
	{"NETRMESSAGENAMEGETINFO", NDR_NETRMESSAGENAMEGETINFO, api_NetrMessageNameGetInfo},
	{"NETRMESSAGENAMEDEL", NDR_NETRMESSAGENAMEDEL, api_NetrMessageNameDel},
};

void msgsvc_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_msgsvc_cmds;
	*n_fns = sizeof(api_msgsvc_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_msgsvc_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_NETRMESSAGENAMEADD: {
			struct NetrMessageNameAdd *r = (struct NetrMessageNameAdd *)_r;
			_NetrMessageNameAdd(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_NETRMESSAGENAMEENUM: {
			struct NetrMessageNameEnum *r = (struct NetrMessageNameEnum *)_r;
			_NetrMessageNameEnum(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_NETRMESSAGENAMEGETINFO: {
			struct NetrMessageNameGetInfo *r = (struct NetrMessageNameGetInfo *)_r;
			_NetrMessageNameGetInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_NETRMESSAGENAMEDEL: {
			struct NetrMessageNameDel *r = (struct NetrMessageNameDel *)_r;
			_NetrMessageNameDel(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_msgsvc_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "msgsvc", "msgsvc", &ndr_table_msgsvc, api_msgsvc_cmds, sizeof(api_msgsvc_cmds) / sizeof(struct api_struct));
}
static bool api_NetrSendMessage(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct NetrSendMessage *r;

	call = &ndr_table_msgsvcsend.calls[NDR_NETRSENDMESSAGE];

	r = talloc(talloc_tos(), struct NetrSendMessage);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(NetrSendMessage, r);
	}

	_NetrSendMessage(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(NetrSendMessage, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_msgsvcsend_cmds[] = 
{
	{"NETRSENDMESSAGE", NDR_NETRSENDMESSAGE, api_NetrSendMessage},
};

void msgsvcsend_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_msgsvcsend_cmds;
	*n_fns = sizeof(api_msgsvcsend_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_msgsvcsend_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_NETRSENDMESSAGE: {
			struct NetrSendMessage *r = (struct NetrSendMessage *)_r;
			_NetrSendMessage(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_msgsvcsend_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "msgsvcsend", "msgsvcsend", &ndr_table_msgsvcsend, api_msgsvcsend_cmds, sizeof(api_msgsvcsend_cmds) / sizeof(struct api_struct));
}
