/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_efs.h"

static bool api_EfsRpcOpenFileRaw(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcOpenFileRaw *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCOPENFILERAW];

	r = talloc(talloc_tos(), struct EfsRpcOpenFileRaw);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcOpenFileRaw, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pvContext = talloc_zero(r, struct policy_handle);
	if (r->out.pvContext == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _EfsRpcOpenFileRaw(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcOpenFileRaw, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcReadFileRaw(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcReadFileRaw *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCREADFILERAW];

	r = talloc(talloc_tos(), struct EfsRpcReadFileRaw);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcReadFileRaw, r);
	}

	r->out.result = _EfsRpcReadFileRaw(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcReadFileRaw, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcWriteFileRaw(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcWriteFileRaw *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCWRITEFILERAW];

	r = talloc(talloc_tos(), struct EfsRpcWriteFileRaw);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcWriteFileRaw, r);
	}

	r->out.result = _EfsRpcWriteFileRaw(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcWriteFileRaw, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcCloseRaw(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcCloseRaw *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCCLOSERAW];

	r = talloc(talloc_tos(), struct EfsRpcCloseRaw);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcCloseRaw, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pvContext = r->in.pvContext;
	_EfsRpcCloseRaw(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcCloseRaw, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcEncryptFileSrv(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcEncryptFileSrv *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCENCRYPTFILESRV];

	r = talloc(talloc_tos(), struct EfsRpcEncryptFileSrv);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcEncryptFileSrv, r);
	}

	r->out.result = _EfsRpcEncryptFileSrv(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcEncryptFileSrv, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcDecryptFileSrv(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcDecryptFileSrv *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCDECRYPTFILESRV];

	r = talloc(talloc_tos(), struct EfsRpcDecryptFileSrv);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcDecryptFileSrv, r);
	}

	r->out.result = _EfsRpcDecryptFileSrv(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcDecryptFileSrv, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcQueryUsersOnFile(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcQueryUsersOnFile *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCQUERYUSERSONFILE];

	r = talloc(talloc_tos(), struct EfsRpcQueryUsersOnFile);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcQueryUsersOnFile, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pUsers = talloc_zero(r, struct ENCRYPTION_CERTIFICATE_HASH_LIST *);
	if (r->out.pUsers == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _EfsRpcQueryUsersOnFile(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcQueryUsersOnFile, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcQueryRecoveryAgents(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcQueryRecoveryAgents *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCQUERYRECOVERYAGENTS];

	r = talloc(talloc_tos(), struct EfsRpcQueryRecoveryAgents);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcQueryRecoveryAgents, r);
	}

	ZERO_STRUCT(r->out);
	r->out.pRecoveryAgents = talloc_zero(r, struct ENCRYPTION_CERTIFICATE_HASH_LIST *);
	if (r->out.pRecoveryAgents == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _EfsRpcQueryRecoveryAgents(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcQueryRecoveryAgents, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcRemoveUsersFromFile(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcRemoveUsersFromFile *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCREMOVEUSERSFROMFILE];

	r = talloc(talloc_tos(), struct EfsRpcRemoveUsersFromFile);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcRemoveUsersFromFile, r);
	}

	r->out.result = _EfsRpcRemoveUsersFromFile(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcRemoveUsersFromFile, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcAddUsersToFile(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcAddUsersToFile *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCADDUSERSTOFILE];

	r = talloc(talloc_tos(), struct EfsRpcAddUsersToFile);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcAddUsersToFile, r);
	}

	r->out.result = _EfsRpcAddUsersToFile(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcAddUsersToFile, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcSetFileEncryptionKey(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcSetFileEncryptionKey *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCSETFILEENCRYPTIONKEY];

	r = talloc(talloc_tos(), struct EfsRpcSetFileEncryptionKey);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcSetFileEncryptionKey, r);
	}

	r->out.result = _EfsRpcSetFileEncryptionKey(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcSetFileEncryptionKey, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcNotSupported(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcNotSupported *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCNOTSUPPORTED];

	r = talloc(talloc_tos(), struct EfsRpcNotSupported);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcNotSupported, r);
	}

	r->out.result = _EfsRpcNotSupported(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcNotSupported, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcFileKeyInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcFileKeyInfo *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCFILEKEYINFO];

	r = talloc(talloc_tos(), struct EfsRpcFileKeyInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcFileKeyInfo, r);
	}

	r->out.result = _EfsRpcFileKeyInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcFileKeyInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_EfsRpcDuplicateEncryptionInfoFile(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct EfsRpcDuplicateEncryptionInfoFile *r;

	call = &ndr_table_efs.calls[NDR_EFSRPCDUPLICATEENCRYPTIONINFOFILE];

	r = talloc(talloc_tos(), struct EfsRpcDuplicateEncryptionInfoFile);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcDuplicateEncryptionInfoFile, r);
	}

	r->out.result = _EfsRpcDuplicateEncryptionInfoFile(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcDuplicateEncryptionInfoFile, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_efs_cmds[] = 
{
	{"EFSRPCOPENFILERAW", NDR_EFSRPCOPENFILERAW, api_EfsRpcOpenFileRaw},
	{"EFSRPCREADFILERAW", NDR_EFSRPCREADFILERAW, api_EfsRpcReadFileRaw},
	{"EFSRPCWRITEFILERAW", NDR_EFSRPCWRITEFILERAW, api_EfsRpcWriteFileRaw},
	{"EFSRPCCLOSERAW", NDR_EFSRPCCLOSERAW, api_EfsRpcCloseRaw},
	{"EFSRPCENCRYPTFILESRV", NDR_EFSRPCENCRYPTFILESRV, api_EfsRpcEncryptFileSrv},
	{"EFSRPCDECRYPTFILESRV", NDR_EFSRPCDECRYPTFILESRV, api_EfsRpcDecryptFileSrv},
	{"EFSRPCQUERYUSERSONFILE", NDR_EFSRPCQUERYUSERSONFILE, api_EfsRpcQueryUsersOnFile},
	{"EFSRPCQUERYRECOVERYAGENTS", NDR_EFSRPCQUERYRECOVERYAGENTS, api_EfsRpcQueryRecoveryAgents},
	{"EFSRPCREMOVEUSERSFROMFILE", NDR_EFSRPCREMOVEUSERSFROMFILE, api_EfsRpcRemoveUsersFromFile},
	{"EFSRPCADDUSERSTOFILE", NDR_EFSRPCADDUSERSTOFILE, api_EfsRpcAddUsersToFile},
	{"EFSRPCSETFILEENCRYPTIONKEY", NDR_EFSRPCSETFILEENCRYPTIONKEY, api_EfsRpcSetFileEncryptionKey},
	{"EFSRPCNOTSUPPORTED", NDR_EFSRPCNOTSUPPORTED, api_EfsRpcNotSupported},
	{"EFSRPCFILEKEYINFO", NDR_EFSRPCFILEKEYINFO, api_EfsRpcFileKeyInfo},
	{"EFSRPCDUPLICATEENCRYPTIONINFOFILE", NDR_EFSRPCDUPLICATEENCRYPTIONINFOFILE, api_EfsRpcDuplicateEncryptionInfoFile},
};

void efs_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_efs_cmds;
	*n_fns = sizeof(api_efs_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_efs_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_EFSRPCOPENFILERAW: {
			struct EfsRpcOpenFileRaw *r = (struct EfsRpcOpenFileRaw *)_r;
			ZERO_STRUCT(r->out);
			r->out.pvContext = talloc_zero(mem_ctx, struct policy_handle);
			if (r->out.pvContext == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _EfsRpcOpenFileRaw(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCREADFILERAW: {
			struct EfsRpcReadFileRaw *r = (struct EfsRpcReadFileRaw *)_r;
			r->out.result = _EfsRpcReadFileRaw(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCWRITEFILERAW: {
			struct EfsRpcWriteFileRaw *r = (struct EfsRpcWriteFileRaw *)_r;
			r->out.result = _EfsRpcWriteFileRaw(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCCLOSERAW: {
			struct EfsRpcCloseRaw *r = (struct EfsRpcCloseRaw *)_r;
			ZERO_STRUCT(r->out);
			r->out.pvContext = r->in.pvContext;
			_EfsRpcCloseRaw(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCENCRYPTFILESRV: {
			struct EfsRpcEncryptFileSrv *r = (struct EfsRpcEncryptFileSrv *)_r;
			r->out.result = _EfsRpcEncryptFileSrv(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCDECRYPTFILESRV: {
			struct EfsRpcDecryptFileSrv *r = (struct EfsRpcDecryptFileSrv *)_r;
			r->out.result = _EfsRpcDecryptFileSrv(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCQUERYUSERSONFILE: {
			struct EfsRpcQueryUsersOnFile *r = (struct EfsRpcQueryUsersOnFile *)_r;
			ZERO_STRUCT(r->out);
			r->out.pUsers = talloc_zero(mem_ctx, struct ENCRYPTION_CERTIFICATE_HASH_LIST *);
			if (r->out.pUsers == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _EfsRpcQueryUsersOnFile(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCQUERYRECOVERYAGENTS: {
			struct EfsRpcQueryRecoveryAgents *r = (struct EfsRpcQueryRecoveryAgents *)_r;
			ZERO_STRUCT(r->out);
			r->out.pRecoveryAgents = talloc_zero(mem_ctx, struct ENCRYPTION_CERTIFICATE_HASH_LIST *);
			if (r->out.pRecoveryAgents == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _EfsRpcQueryRecoveryAgents(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCREMOVEUSERSFROMFILE: {
			struct EfsRpcRemoveUsersFromFile *r = (struct EfsRpcRemoveUsersFromFile *)_r;
			r->out.result = _EfsRpcRemoveUsersFromFile(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCADDUSERSTOFILE: {
			struct EfsRpcAddUsersToFile *r = (struct EfsRpcAddUsersToFile *)_r;
			r->out.result = _EfsRpcAddUsersToFile(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCSETFILEENCRYPTIONKEY: {
			struct EfsRpcSetFileEncryptionKey *r = (struct EfsRpcSetFileEncryptionKey *)_r;
			r->out.result = _EfsRpcSetFileEncryptionKey(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCNOTSUPPORTED: {
			struct EfsRpcNotSupported *r = (struct EfsRpcNotSupported *)_r;
			r->out.result = _EfsRpcNotSupported(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCFILEKEYINFO: {
			struct EfsRpcFileKeyInfo *r = (struct EfsRpcFileKeyInfo *)_r;
			r->out.result = _EfsRpcFileKeyInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_EFSRPCDUPLICATEENCRYPTIONINFOFILE: {
			struct EfsRpcDuplicateEncryptionInfoFile *r = (struct EfsRpcDuplicateEncryptionInfoFile *)_r;
			r->out.result = _EfsRpcDuplicateEncryptionInfoFile(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_efs_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "efs", "efs", &ndr_table_efs, api_efs_cmds, sizeof(api_efs_cmds) / sizeof(struct api_struct));
}
