/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_dfsblobs.h"

static bool api_dfs_GetDFSReferral(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct dfs_GetDFSReferral *r;

	call = &ndr_table_dfsblobs.calls[NDR_DFS_GETDFSREFERRAL];

	r = talloc(talloc_tos(), struct dfs_GetDFSReferral);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(dfs_GetDFSReferral, r);
	}

	ZERO_STRUCT(r->out);
	r->out.resp = talloc_zero(r, struct dfs_referral_resp);
	if (r->out.resp == NULL) {
		talloc_free(r);
		return false;
	}

	_dfs_GetDFSReferral(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(dfs_GetDFSReferral, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_dfsblobs_cmds[] = 
{
	{"DFS_GETDFSREFERRAL", NDR_DFS_GETDFSREFERRAL, api_dfs_GetDFSReferral},
};

void dfsblobs_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_dfsblobs_cmds;
	*n_fns = sizeof(api_dfsblobs_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_dfsblobs_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_DFS_GETDFSREFERRAL: {
			struct dfs_GetDFSReferral *r = (struct dfs_GetDFSReferral *)_r;
			ZERO_STRUCT(r->out);
			r->out.resp = talloc_zero(mem_ctx, struct dfs_referral_resp);
			if (r->out.resp == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			_dfs_GetDFSReferral(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_dfsblobs_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "dfsblobs", "dfsblobs", &ndr_table_dfsblobs, api_dfsblobs_cmds, sizeof(api_dfsblobs_cmds) / sizeof(struct api_struct));
}
