/*
 * Unix SMB/CIFS implementation.
 * server auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/srv_atsvc.h"

static bool api_atsvc_JobAdd(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct atsvc_JobAdd *r;

	call = &ndr_table_atsvc.calls[NDR_ATSVC_JOBADD];

	r = talloc(talloc_tos(), struct atsvc_JobAdd);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobAdd, r);
	}

	ZERO_STRUCT(r->out);
	r->out.job_id = talloc_zero(r, uint32_t);
	if (r->out.job_id == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _atsvc_JobAdd(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobAdd, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_atsvc_JobDel(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct atsvc_JobDel *r;

	call = &ndr_table_atsvc.calls[NDR_ATSVC_JOBDEL];

	r = talloc(talloc_tos(), struct atsvc_JobDel);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobDel, r);
	}

	r->out.result = _atsvc_JobDel(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobDel, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_atsvc_JobEnum(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct atsvc_JobEnum *r;

	call = &ndr_table_atsvc.calls[NDR_ATSVC_JOBENUM];

	r = talloc(talloc_tos(), struct atsvc_JobEnum);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobEnum, r);
	}

	ZERO_STRUCT(r->out);
	r->out.ctr = r->in.ctr;
	r->out.resume_handle = r->in.resume_handle;
	r->out.total_entries = talloc_zero(r, uint32_t);
	if (r->out.total_entries == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _atsvc_JobEnum(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobEnum, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}

static bool api_atsvc_JobGetInfo(pipes_struct *p)
{
	const struct ndr_interface_call *call;
	struct ndr_pull *pull;
	struct ndr_push *push;
	enum ndr_err_code ndr_err;
	DATA_BLOB blob;
	struct atsvc_JobGetInfo *r;

	call = &ndr_table_atsvc.calls[NDR_ATSVC_JOBGETINFO];

	r = talloc(talloc_tos(), struct atsvc_JobGetInfo);
	if (r == NULL) {
		return false;
	}

	if (!prs_data_blob(&p->in_data.data, &blob, r)) {
		talloc_free(r);
		return false;
	}

	pull = ndr_pull_init_blob(&blob, r, NULL);
	if (pull == NULL) {
		talloc_free(r);
		return false;
	}

	pull->flags |= LIBNDR_FLAG_REF_ALLOC;
	ndr_err = call->ndr_pull(pull, NDR_IN, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(atsvc_JobGetInfo, r);
	}

	ZERO_STRUCT(r->out);
	r->out.job_info = talloc_zero(r, struct atsvc_JobInfo *);
	if (r->out.job_info == NULL) {
		talloc_free(r);
		return false;
	}

	r->out.result = _atsvc_JobGetInfo(p, r);

	if (p->rng_fault_state) {
		talloc_free(r);
		/* Return true here, srv_pipe_hnd.c will take care */
		return true;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(atsvc_JobGetInfo, r);
	}

	push = ndr_push_init_ctx(r, NULL);
	if (push == NULL) {
		talloc_free(r);
		return false;
	}

	ndr_err = call->ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		talloc_free(r);
		return false;
	}

	blob = ndr_push_blob(push);
	if (!prs_copy_data_in(&p->out_data.rdata, (const char *)blob.data, (uint32_t)blob.length)) {
		talloc_free(r);
		return false;
	}

	talloc_free(r);

	return true;
}


/* Tables */
static struct api_struct api_atsvc_cmds[] = 
{
	{"ATSVC_JOBADD", NDR_ATSVC_JOBADD, api_atsvc_JobAdd},
	{"ATSVC_JOBDEL", NDR_ATSVC_JOBDEL, api_atsvc_JobDel},
	{"ATSVC_JOBENUM", NDR_ATSVC_JOBENUM, api_atsvc_JobEnum},
	{"ATSVC_JOBGETINFO", NDR_ATSVC_JOBGETINFO, api_atsvc_JobGetInfo},
};

void atsvc_get_pipe_fns(struct api_struct **fns, int *n_fns)
{
	*fns = api_atsvc_cmds;
	*n_fns = sizeof(api_atsvc_cmds) / sizeof(struct api_struct);
}

NTSTATUS rpc_atsvc_dispatch(struct rpc_pipe_client *cli, TALLOC_CTX *mem_ctx, const struct ndr_interface_table *table, uint32_t opnum, void *_r)
{
	if (cli->pipes_struct == NULL) {
		return NT_STATUS_INVALID_PARAMETER;
	}

	switch (opnum)
	{
		case NDR_ATSVC_JOBADD: {
			struct atsvc_JobAdd *r = (struct atsvc_JobAdd *)_r;
			ZERO_STRUCT(r->out);
			r->out.job_id = talloc_zero(mem_ctx, uint32_t);
			if (r->out.job_id == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _atsvc_JobAdd(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ATSVC_JOBDEL: {
			struct atsvc_JobDel *r = (struct atsvc_JobDel *)_r;
			r->out.result = _atsvc_JobDel(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ATSVC_JOBENUM: {
			struct atsvc_JobEnum *r = (struct atsvc_JobEnum *)_r;
			ZERO_STRUCT(r->out);
			r->out.ctr = r->in.ctr;
			r->out.resume_handle = r->in.resume_handle;
			r->out.total_entries = talloc_zero(mem_ctx, uint32_t);
			if (r->out.total_entries == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _atsvc_JobEnum(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		case NDR_ATSVC_JOBGETINFO: {
			struct atsvc_JobGetInfo *r = (struct atsvc_JobGetInfo *)_r;
			ZERO_STRUCT(r->out);
			r->out.job_info = talloc_zero(mem_ctx, struct atsvc_JobInfo *);
			if (r->out.job_info == NULL) {
			return NT_STATUS_NO_MEMORY;
			}

			r->out.result = _atsvc_JobGetInfo(cli->pipes_struct, r);
			return NT_STATUS_OK;
		}

		default:
			return NT_STATUS_NOT_IMPLEMENTED;
	}
}

NTSTATUS rpc_atsvc_init(void)
{
	return rpc_srv_register(SMB_RPC_INTERFACE_VERSION, "atsvc", "atsvc", &ndr_table_atsvc, api_atsvc_cmds, sizeof(api_atsvc_cmds) / sizeof(struct api_struct));
}
