
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_named_pipe_auth.h"
#include "../librpc/gen_ndr/ndr_named_pipe_auth_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/netlogon.h"
staticforward PyTypeObject named_pipe_auth_req_info2_Type;
staticforward PyTypeObject named_pipe_auth_req_info3_Type;
staticforward PyTypeObject named_pipe_auth_req_Type;
staticforward PyTypeObject named_pipe_auth_rep_info2_Type;
staticforward PyTypeObject named_pipe_auth_rep_info3_Type;
staticforward PyTypeObject named_pipe_auth_rep_Type;

static PyTypeObject *netr_SamInfo3_Type;

static PyObject *py_named_pipe_auth_req_info2_get_client_name(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->client_name == NULL) {
		py_client_name = Py_None;
	} else {
		py_client_name = PyUnicode_Decode(object->client_name, strlen(object->client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_named_pipe_auth_req_info2_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->client_name = NULL;
	} else {
		object->client_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->client_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->client_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_client_addr(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_client_addr;
	if (object->client_addr == NULL) {
		py_client_addr = Py_None;
	} else {
		py_client_addr = PyUnicode_Decode(object->client_addr, strlen(object->client_addr), "utf-8", "ignore");
	}
	return py_client_addr;
}

static int py_named_pipe_auth_req_info2_set_client_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->client_addr = NULL;
	} else {
		object->client_addr = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->client_addr);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->client_addr = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_client_port(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_client_port;
	py_client_port = PyInt_FromLong(object->client_port);
	return py_client_port;
}

static int py_named_pipe_auth_req_info2_set_client_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->client_port = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_server_name(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		py_server_name = Py_None;
	} else {
		py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
	}
	return py_server_name;
}

static int py_named_pipe_auth_req_info2_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->server_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_server_addr(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_server_addr;
	if (object->server_addr == NULL) {
		py_server_addr = Py_None;
	} else {
		py_server_addr = PyUnicode_Decode(object->server_addr, strlen(object->server_addr), "utf-8", "ignore");
	}
	return py_server_addr;
}

static int py_named_pipe_auth_req_info2_set_server_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->server_addr = NULL;
	} else {
		object->server_addr = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->server_addr);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->server_addr = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_server_port(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_server_port;
	py_server_port = PyInt_FromLong(object->server_port);
	return py_server_port;
}

static int py_named_pipe_auth_req_info2_set_server_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_port = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_sam_info3(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_sam_info3;
	if (object->sam_info3 == NULL) {
		py_sam_info3 = Py_None;
	} else {
		py_sam_info3 = py_talloc_reference_ex(netr_SamInfo3_Type, object->sam_info3, object->sam_info3);
	}
	return py_sam_info3;
}

static int py_named_pipe_auth_req_info2_set_sam_info3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sam_info3);
	if (value == Py_None) {
		object->sam_info3 = NULL;
	} else {
		object->sam_info3 = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sam_info3);
		PY_CHECK_TYPE(netr_SamInfo3_Type, value, return -1;);
		object->sam_info3 = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_session_key_length(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_session_key_length;
	py_session_key_length = PyInt_FromLong(object->session_key_length);
	return py_session_key_length;
}

static int py_named_pipe_auth_req_info2_set_session_key_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->session_key_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_info2_get_session_key(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_session_key;
	if (object->session_key == NULL) {
		py_session_key = Py_None;
	} else {
		py_session_key = PyList_New(object->session_key_length);
		if (py_session_key == NULL) {
			return NULL;
		}
		{
			int session_key_cntr_1;
			for (session_key_cntr_1 = 0; session_key_cntr_1 < object->session_key_length; session_key_cntr_1++) {
				PyObject *py_session_key_1;
				py_session_key_1 = PyInt_FromLong(object->session_key[session_key_cntr_1]);
				PyList_SetItem(py_session_key, session_key_cntr_1, py_session_key_1);
			}
		}
	}
	return py_session_key;
}

static int py_named_pipe_auth_req_info2_set_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info2 *object = (struct named_pipe_auth_req_info2 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->session_key);
	if (value == Py_None) {
		object->session_key = NULL;
	} else {
		object->session_key = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->session_key);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int session_key_cntr_1;
			object->session_key = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->session_key, PyList_Size(value));
			for (session_key_cntr_1 = 0; session_key_cntr_1 < PyList_Size(value); session_key_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, session_key_cntr_1), return -1;);
				object->session_key[session_key_cntr_1] = PyInt_AsLong(PyList_GetItem(value, session_key_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_named_pipe_auth_req_info2_getsetters[] = {
	{ discard_const_p(char, "client_name"), py_named_pipe_auth_req_info2_get_client_name, py_named_pipe_auth_req_info2_set_client_name },
	{ discard_const_p(char, "client_addr"), py_named_pipe_auth_req_info2_get_client_addr, py_named_pipe_auth_req_info2_set_client_addr },
	{ discard_const_p(char, "client_port"), py_named_pipe_auth_req_info2_get_client_port, py_named_pipe_auth_req_info2_set_client_port },
	{ discard_const_p(char, "server_name"), py_named_pipe_auth_req_info2_get_server_name, py_named_pipe_auth_req_info2_set_server_name },
	{ discard_const_p(char, "server_addr"), py_named_pipe_auth_req_info2_get_server_addr, py_named_pipe_auth_req_info2_set_server_addr },
	{ discard_const_p(char, "server_port"), py_named_pipe_auth_req_info2_get_server_port, py_named_pipe_auth_req_info2_set_server_port },
	{ discard_const_p(char, "sam_info3"), py_named_pipe_auth_req_info2_get_sam_info3, py_named_pipe_auth_req_info2_set_sam_info3 },
	{ discard_const_p(char, "session_key_length"), py_named_pipe_auth_req_info2_get_session_key_length, py_named_pipe_auth_req_info2_set_session_key_length },
	{ discard_const_p(char, "session_key"), py_named_pipe_auth_req_info2_get_session_key, py_named_pipe_auth_req_info2_set_session_key },
	{ NULL }
};

static PyObject *py_named_pipe_auth_req_info2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_req_info2, type);
}


static PyTypeObject named_pipe_auth_req_info2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.req_info2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_req_info2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_req_info2_new,
};


static PyObject *py_named_pipe_auth_req_info3_get_client_name(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_client_name;
	if (object->client_name == NULL) {
		py_client_name = Py_None;
	} else {
		py_client_name = PyUnicode_Decode(object->client_name, strlen(object->client_name), "utf-8", "ignore");
	}
	return py_client_name;
}

static int py_named_pipe_auth_req_info3_set_client_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->client_name = NULL;
	} else {
		object->client_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->client_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->client_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_client_addr(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_client_addr;
	if (object->client_addr == NULL) {
		py_client_addr = Py_None;
	} else {
		py_client_addr = PyUnicode_Decode(object->client_addr, strlen(object->client_addr), "utf-8", "ignore");
	}
	return py_client_addr;
}

static int py_named_pipe_auth_req_info3_set_client_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->client_addr = NULL;
	} else {
		object->client_addr = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->client_addr);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->client_addr = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_client_port(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_client_port;
	py_client_port = PyInt_FromLong(object->client_port);
	return py_client_port;
}

static int py_named_pipe_auth_req_info3_set_client_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->client_port = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_server_name(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_server_name;
	if (object->server_name == NULL) {
		py_server_name = Py_None;
	} else {
		py_server_name = PyUnicode_Decode(object->server_name, strlen(object->server_name), "utf-8", "ignore");
	}
	return py_server_name;
}

static int py_named_pipe_auth_req_info3_set_server_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->server_name = NULL;
	} else {
		object->server_name = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->server_name);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->server_name = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_server_addr(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_server_addr;
	if (object->server_addr == NULL) {
		py_server_addr = Py_None;
	} else {
		py_server_addr = PyUnicode_Decode(object->server_addr, strlen(object->server_addr), "utf-8", "ignore");
	}
	return py_server_addr;
}

static int py_named_pipe_auth_req_info3_set_server_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->server_addr = NULL;
	} else {
		object->server_addr = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->server_addr);
		PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
		object->server_addr = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_server_port(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_server_port;
	py_server_port = PyInt_FromLong(object->server_port);
	return py_server_port;
}

static int py_named_pipe_auth_req_info3_set_server_port(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_port = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_sam_info3(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_sam_info3;
	if (object->sam_info3 == NULL) {
		py_sam_info3 = Py_None;
	} else {
		py_sam_info3 = py_talloc_reference_ex(netr_SamInfo3_Type, object->sam_info3, object->sam_info3);
	}
	return py_sam_info3;
}

static int py_named_pipe_auth_req_info3_set_sam_info3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->sam_info3);
	if (value == Py_None) {
		object->sam_info3 = NULL;
	} else {
		object->sam_info3 = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->sam_info3);
		PY_CHECK_TYPE(netr_SamInfo3_Type, value, return -1;);
		object->sam_info3 = py_talloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_session_key_length(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_session_key_length;
	py_session_key_length = PyInt_FromLong(object->session_key_length);
	return py_session_key_length;
}

static int py_named_pipe_auth_req_info3_set_session_key_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->session_key_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_session_key(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_session_key;
	if (object->session_key == NULL) {
		py_session_key = Py_None;
	} else {
		py_session_key = PyList_New(object->session_key_length);
		if (py_session_key == NULL) {
			return NULL;
		}
		{
			int session_key_cntr_1;
			for (session_key_cntr_1 = 0; session_key_cntr_1 < object->session_key_length; session_key_cntr_1++) {
				PyObject *py_session_key_1;
				py_session_key_1 = PyInt_FromLong(object->session_key[session_key_cntr_1]);
				PyList_SetItem(py_session_key, session_key_cntr_1, py_session_key_1);
			}
		}
	}
	return py_session_key;
}

static int py_named_pipe_auth_req_info3_set_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->session_key);
	if (value == Py_None) {
		object->session_key = NULL;
	} else {
		object->session_key = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->session_key);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int session_key_cntr_1;
			object->session_key = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->session_key, PyList_Size(value));
			for (session_key_cntr_1 = 0; session_key_cntr_1 < PyList_Size(value); session_key_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, session_key_cntr_1), return -1;);
				object->session_key[session_key_cntr_1] = PyInt_AsLong(PyList_GetItem(value, session_key_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_gssapi_delegated_creds_length(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_gssapi_delegated_creds_length;
	py_gssapi_delegated_creds_length = PyInt_FromLong(object->gssapi_delegated_creds_length);
	return py_gssapi_delegated_creds_length;
}

static int py_named_pipe_auth_req_info3_set_gssapi_delegated_creds_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->gssapi_delegated_creds_length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_info3_get_gssapi_delegated_creds(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_gssapi_delegated_creds;
	if (object->gssapi_delegated_creds == NULL) {
		py_gssapi_delegated_creds = Py_None;
	} else {
		py_gssapi_delegated_creds = PyList_New(object->gssapi_delegated_creds_length);
		if (py_gssapi_delegated_creds == NULL) {
			return NULL;
		}
		{
			int gssapi_delegated_creds_cntr_1;
			for (gssapi_delegated_creds_cntr_1 = 0; gssapi_delegated_creds_cntr_1 < object->gssapi_delegated_creds_length; gssapi_delegated_creds_cntr_1++) {
				PyObject *py_gssapi_delegated_creds_1;
				py_gssapi_delegated_creds_1 = PyInt_FromLong(object->gssapi_delegated_creds[gssapi_delegated_creds_cntr_1]);
				PyList_SetItem(py_gssapi_delegated_creds, gssapi_delegated_creds_cntr_1, py_gssapi_delegated_creds_1);
			}
		}
	}
	return py_gssapi_delegated_creds;
}

static int py_named_pipe_auth_req_info3_set_gssapi_delegated_creds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req_info3 *object = (struct named_pipe_auth_req_info3 *)py_talloc_get_ptr(py_obj);
	talloc_free(object->gssapi_delegated_creds);
	if (value == Py_None) {
		object->gssapi_delegated_creds = NULL;
	} else {
		object->gssapi_delegated_creds = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->gssapi_delegated_creds);
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int gssapi_delegated_creds_cntr_1;
			object->gssapi_delegated_creds = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->gssapi_delegated_creds, PyList_Size(value));
			for (gssapi_delegated_creds_cntr_1 = 0; gssapi_delegated_creds_cntr_1 < PyList_Size(value); gssapi_delegated_creds_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, gssapi_delegated_creds_cntr_1), return -1;);
				object->gssapi_delegated_creds[gssapi_delegated_creds_cntr_1] = PyInt_AsLong(PyList_GetItem(value, gssapi_delegated_creds_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_named_pipe_auth_req_info3_getsetters[] = {
	{ discard_const_p(char, "client_name"), py_named_pipe_auth_req_info3_get_client_name, py_named_pipe_auth_req_info3_set_client_name },
	{ discard_const_p(char, "client_addr"), py_named_pipe_auth_req_info3_get_client_addr, py_named_pipe_auth_req_info3_set_client_addr },
	{ discard_const_p(char, "client_port"), py_named_pipe_auth_req_info3_get_client_port, py_named_pipe_auth_req_info3_set_client_port },
	{ discard_const_p(char, "server_name"), py_named_pipe_auth_req_info3_get_server_name, py_named_pipe_auth_req_info3_set_server_name },
	{ discard_const_p(char, "server_addr"), py_named_pipe_auth_req_info3_get_server_addr, py_named_pipe_auth_req_info3_set_server_addr },
	{ discard_const_p(char, "server_port"), py_named_pipe_auth_req_info3_get_server_port, py_named_pipe_auth_req_info3_set_server_port },
	{ discard_const_p(char, "sam_info3"), py_named_pipe_auth_req_info3_get_sam_info3, py_named_pipe_auth_req_info3_set_sam_info3 },
	{ discard_const_p(char, "session_key_length"), py_named_pipe_auth_req_info3_get_session_key_length, py_named_pipe_auth_req_info3_set_session_key_length },
	{ discard_const_p(char, "session_key"), py_named_pipe_auth_req_info3_get_session_key, py_named_pipe_auth_req_info3_set_session_key },
	{ discard_const_p(char, "gssapi_delegated_creds_length"), py_named_pipe_auth_req_info3_get_gssapi_delegated_creds_length, py_named_pipe_auth_req_info3_set_gssapi_delegated_creds_length },
	{ discard_const_p(char, "gssapi_delegated_creds"), py_named_pipe_auth_req_info3_get_gssapi_delegated_creds, py_named_pipe_auth_req_info3_set_gssapi_delegated_creds },
	{ NULL }
};

static PyObject *py_named_pipe_auth_req_info3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_req_info3, type);
}


static PyTypeObject named_pipe_auth_req_info3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.req_info3",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_req_info3_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_req_info3_new,
};

PyObject *py_import_named_pipe_auth_req_info(TALLOC_CTX *mem_ctx, int level, union named_pipe_auth_req_info *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = Py_None;
			return ret;

		case 1:
			ret = py_talloc_reference_ex(netr_SamInfo3_Type, mem_ctx, &in->info1);
			return ret;

		case 2:
			ret = py_talloc_reference_ex(&named_pipe_auth_req_info2_Type, mem_ctx, &in->info2);
			return ret;

		case 3:
			ret = py_talloc_reference_ex(&named_pipe_auth_req_info3_Type, mem_ctx, &in->info3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union named_pipe_auth_req_info *py_export_named_pipe_auth_req_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union named_pipe_auth_req_info *ret = talloc_zero(mem_ctx, union named_pipe_auth_req_info);
	switch (level) {
		case 0:
			break;

		case 1:
			PY_CHECK_TYPE(netr_SamInfo3_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->info1, py_talloc_get_ptr(in), sizeof(ret->info1));
			break;

		case 2:
			PY_CHECK_TYPE(&named_pipe_auth_req_info2_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->info2, py_talloc_get_ptr(in), sizeof(ret->info2));
			break;

		case 3:
			PY_CHECK_TYPE(&named_pipe_auth_req_info3_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->info3, py_talloc_get_ptr(in), sizeof(ret->info3));
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_named_pipe_auth_req_get_length(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_named_pipe_auth_req_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_get_magic(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyUnicode_Decode(object->magic, strlen(object->magic), "utf-8", "ignore");
	return py_magic;
}

static int py_named_pipe_auth_req_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->magic = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_named_pipe_auth_req_get_level(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyInt_FromLong(object->level);
	return py_level;
}

static int py_named_pipe_auth_req_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->level = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_req_get_info(PyObject *obj, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(obj);
	PyObject *py_info;
	py_info = py_import_named_pipe_auth_req_info(py_talloc_get_mem_ctx(obj), object->level, &object->info);
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_named_pipe_auth_req_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	memcpy(&object->info, py_export_named_pipe_auth_req_info(py_talloc_get_mem_ctx(py_obj), object->level, value), sizeof(object->info));
	return 0;
}

static PyGetSetDef py_named_pipe_auth_req_getsetters[] = {
	{ discard_const_p(char, "length"), py_named_pipe_auth_req_get_length, py_named_pipe_auth_req_set_length },
	{ discard_const_p(char, "magic"), py_named_pipe_auth_req_get_magic, py_named_pipe_auth_req_set_magic },
	{ discard_const_p(char, "level"), py_named_pipe_auth_req_get_level, py_named_pipe_auth_req_set_level },
	{ discard_const_p(char, "info"), py_named_pipe_auth_req_get_info, py_named_pipe_auth_req_set_info },
	{ NULL }
};

static PyObject *py_named_pipe_auth_req_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_req, type);
}

static PyObject *py_named_pipe_auth_req_ndr_pack(PyObject *py_obj)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_named_pipe_auth_req);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_named_pipe_auth_req_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct named_pipe_auth_req *object = (struct named_pipe_auth_req *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_named_pipe_auth_req);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_named_pipe_auth_req_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_named_pipe_auth_req_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_named_pipe_auth_req_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject named_pipe_auth_req_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.req",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_req_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_named_pipe_auth_req_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_req_new,
};


static PyObject *py_named_pipe_auth_rep_info2_get_file_type(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep_info2 *object = (struct named_pipe_auth_rep_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_file_type;
	py_file_type = PyInt_FromLong(object->file_type);
	return py_file_type;
}

static int py_named_pipe_auth_rep_info2_set_file_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep_info2 *object = (struct named_pipe_auth_rep_info2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->file_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_info2_get_device_state(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep_info2 *object = (struct named_pipe_auth_rep_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_device_state;
	py_device_state = PyInt_FromLong(object->device_state);
	return py_device_state;
}

static int py_named_pipe_auth_rep_info2_set_device_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep_info2 *object = (struct named_pipe_auth_rep_info2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->device_state = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_info2_get_allocation_size(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep_info2 *object = (struct named_pipe_auth_rep_info2 *)py_talloc_get_ptr(obj);
	PyObject *py_allocation_size;
	py_allocation_size = PyInt_FromLong(object->allocation_size);
	return py_allocation_size;
}

static int py_named_pipe_auth_rep_info2_set_allocation_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep_info2 *object = (struct named_pipe_auth_rep_info2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->allocation_size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_named_pipe_auth_rep_info2_getsetters[] = {
	{ discard_const_p(char, "file_type"), py_named_pipe_auth_rep_info2_get_file_type, py_named_pipe_auth_rep_info2_set_file_type },
	{ discard_const_p(char, "device_state"), py_named_pipe_auth_rep_info2_get_device_state, py_named_pipe_auth_rep_info2_set_device_state },
	{ discard_const_p(char, "allocation_size"), py_named_pipe_auth_rep_info2_get_allocation_size, py_named_pipe_auth_rep_info2_set_allocation_size },
	{ NULL }
};

static PyObject *py_named_pipe_auth_rep_info2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_rep_info2, type);
}


static PyTypeObject named_pipe_auth_rep_info2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.rep_info2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_rep_info2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_rep_info2_new,
};


static PyObject *py_named_pipe_auth_rep_info3_get_file_type(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep_info3 *object = (struct named_pipe_auth_rep_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_file_type;
	py_file_type = PyInt_FromLong(object->file_type);
	return py_file_type;
}

static int py_named_pipe_auth_rep_info3_set_file_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep_info3 *object = (struct named_pipe_auth_rep_info3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->file_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_info3_get_device_state(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep_info3 *object = (struct named_pipe_auth_rep_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_device_state;
	py_device_state = PyInt_FromLong(object->device_state);
	return py_device_state;
}

static int py_named_pipe_auth_rep_info3_set_device_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep_info3 *object = (struct named_pipe_auth_rep_info3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->device_state = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_info3_get_allocation_size(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep_info3 *object = (struct named_pipe_auth_rep_info3 *)py_talloc_get_ptr(obj);
	PyObject *py_allocation_size;
	py_allocation_size = PyInt_FromLong(object->allocation_size);
	return py_allocation_size;
}

static int py_named_pipe_auth_rep_info3_set_allocation_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep_info3 *object = (struct named_pipe_auth_rep_info3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->allocation_size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_named_pipe_auth_rep_info3_getsetters[] = {
	{ discard_const_p(char, "file_type"), py_named_pipe_auth_rep_info3_get_file_type, py_named_pipe_auth_rep_info3_set_file_type },
	{ discard_const_p(char, "device_state"), py_named_pipe_auth_rep_info3_get_device_state, py_named_pipe_auth_rep_info3_set_device_state },
	{ discard_const_p(char, "allocation_size"), py_named_pipe_auth_rep_info3_get_allocation_size, py_named_pipe_auth_rep_info3_set_allocation_size },
	{ NULL }
};

static PyObject *py_named_pipe_auth_rep_info3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_rep_info3, type);
}


static PyTypeObject named_pipe_auth_rep_info3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.rep_info3",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_rep_info3_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_rep_info3_new,
};

PyObject *py_import_named_pipe_auth_rep_info(TALLOC_CTX *mem_ctx, int level, union named_pipe_auth_rep_info *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = Py_None;
			return ret;

		case 1:
			ret = Py_None;
			return ret;

		case 2:
			ret = py_talloc_reference_ex(&named_pipe_auth_rep_info2_Type, mem_ctx, &in->info2);
			return ret;

		case 3:
			ret = py_talloc_reference_ex(&named_pipe_auth_rep_info3_Type, mem_ctx, &in->info3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union named_pipe_auth_rep_info *py_export_named_pipe_auth_rep_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union named_pipe_auth_rep_info *ret = talloc_zero(mem_ctx, union named_pipe_auth_rep_info);
	switch (level) {
		case 0:
			break;

		case 1:
			break;

		case 2:
			PY_CHECK_TYPE(&named_pipe_auth_rep_info2_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->info2, py_talloc_get_ptr(in), sizeof(ret->info2));
			break;

		case 3:
			PY_CHECK_TYPE(&named_pipe_auth_rep_info3_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->info3, py_talloc_get_ptr(in), sizeof(ret->info3));
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_named_pipe_auth_rep_get_length(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyInt_FromLong(object->length);
	return py_length;
}

static int py_named_pipe_auth_rep_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->length = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_magic(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyUnicode_Decode(object->magic, strlen(object->magic), "utf-8", "ignore");
	return py_magic;
}

static int py_named_pipe_auth_rep_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyUnicode_Type, value, return -1;);
	object->magic = PyString_AsString(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_level(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyInt_FromLong(object->level);
	return py_level;
}

static int py_named_pipe_auth_rep_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->level = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_info(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_info;
	py_info = py_import_named_pipe_auth_rep_info(py_talloc_get_mem_ctx(obj), object->level, &object->info);
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_named_pipe_auth_rep_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	memcpy(&object->info, py_export_named_pipe_auth_rep_info(py_talloc_get_mem_ctx(py_obj), object->level, value), sizeof(object->info));
	return 0;
}

static PyObject *py_named_pipe_auth_rep_get_status(PyObject *obj, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_named_pipe_auth_rep_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	object->status = NT_STATUS(PyInt_AsLong(value));
	return 0;
}

static PyGetSetDef py_named_pipe_auth_rep_getsetters[] = {
	{ discard_const_p(char, "length"), py_named_pipe_auth_rep_get_length, py_named_pipe_auth_rep_set_length },
	{ discard_const_p(char, "magic"), py_named_pipe_auth_rep_get_magic, py_named_pipe_auth_rep_set_magic },
	{ discard_const_p(char, "level"), py_named_pipe_auth_rep_get_level, py_named_pipe_auth_rep_set_level },
	{ discard_const_p(char, "info"), py_named_pipe_auth_rep_get_info, py_named_pipe_auth_rep_set_info },
	{ discard_const_p(char, "status"), py_named_pipe_auth_rep_get_status, py_named_pipe_auth_rep_set_status },
	{ NULL }
};

static PyObject *py_named_pipe_auth_rep_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct named_pipe_auth_rep, type);
}

static PyObject *py_named_pipe_auth_rep_ndr_pack(PyObject *py_obj)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_named_pipe_auth_rep);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_named_pipe_auth_rep_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct named_pipe_auth_rep *object = (struct named_pipe_auth_rep *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_named_pipe_auth_rep);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_named_pipe_auth_rep_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_named_pipe_auth_rep_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_named_pipe_auth_rep_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject named_pipe_auth_rep_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "named_pipe_auth.rep",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_named_pipe_auth_rep_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_named_pipe_auth_rep_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_named_pipe_auth_rep_new,
};

static PyMethodDef named_pipe_auth_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initnamed_pipe_auth(void)
{
	PyObject *m;
	PyObject *dep_netlogon;

	dep_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_netlogon == NULL)
		return;

	netr_SamInfo3_Type = (PyTypeObject *)PyObject_GetAttrString(dep_netlogon, "netr_SamInfo3");
	if (netr_SamInfo3_Type == NULL)
		return;

	if (PyType_Ready(&named_pipe_auth_req_info2_Type) < 0)
		return;
	if (PyType_Ready(&named_pipe_auth_req_info3_Type) < 0)
		return;
	if (PyType_Ready(&named_pipe_auth_req_Type) < 0)
		return;
	if (PyType_Ready(&named_pipe_auth_rep_info2_Type) < 0)
		return;
	if (PyType_Ready(&named_pipe_auth_rep_info3_Type) < 0)
		return;
	if (PyType_Ready(&named_pipe_auth_rep_Type) < 0)
		return;
#ifdef PY_REQ_INFO2_PATCH
	PY_REQ_INFO2_PATCH(&named_pipe_auth_req_info2_Type);
#endif
#ifdef PY_REQ_INFO3_PATCH
	PY_REQ_INFO3_PATCH(&named_pipe_auth_req_info3_Type);
#endif
#ifdef PY_REQ_PATCH
	PY_REQ_PATCH(&named_pipe_auth_req_Type);
#endif
#ifdef PY_REP_INFO2_PATCH
	PY_REP_INFO2_PATCH(&named_pipe_auth_rep_info2_Type);
#endif
#ifdef PY_REP_INFO3_PATCH
	PY_REP_INFO3_PATCH(&named_pipe_auth_rep_info3_Type);
#endif
#ifdef PY_REP_PATCH
	PY_REP_PATCH(&named_pipe_auth_rep_Type);
#endif

	m = Py_InitModule3("named_pipe_auth", named_pipe_auth_methods, "named_pipe_auth DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "NAMED_PIPE_AUTH_MAGIC", PyString_FromString("NPAM"));
	Py_INCREF((PyObject *)&named_pipe_auth_req_info2_Type);
	PyModule_AddObject(m, "req_info2", (PyObject *)&named_pipe_auth_req_info2_Type);
	Py_INCREF((PyObject *)&named_pipe_auth_req_info3_Type);
	PyModule_AddObject(m, "req_info3", (PyObject *)&named_pipe_auth_req_info3_Type);
	Py_INCREF((PyObject *)&named_pipe_auth_req_Type);
	PyModule_AddObject(m, "req", (PyObject *)&named_pipe_auth_req_Type);
	Py_INCREF((PyObject *)&named_pipe_auth_rep_info2_Type);
	PyModule_AddObject(m, "rep_info2", (PyObject *)&named_pipe_auth_rep_info2_Type);
	Py_INCREF((PyObject *)&named_pipe_auth_rep_info3_Type);
	PyModule_AddObject(m, "rep_info3", (PyObject *)&named_pipe_auth_rep_info3_Type);
	Py_INCREF((PyObject *)&named_pipe_auth_rep_Type);
	PyModule_AddObject(m, "rep", (PyObject *)&named_pipe_auth_rep_Type);
#ifdef PY_MOD_NAMED_PIPE_AUTH_PATCH
	PY_MOD_NAMED_PIPE_AUTH_PATCH(m);
#endif

}
