
/* Python wrapper functions auto-generated by pidl */
#include "includes.h"
#include <Python.h>
#include "librpc/rpc/dcerpc.h"
#include "lib/talloc/pytalloc.h"
#include "librpc/rpc/pyrpc.h"
#include "../librpc/gen_ndr/ndr_dfsblobs.h"
#include "../librpc/gen_ndr/ndr_dfsblobs_c.h"

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE return Py_INCREF(Py_None), Py_None
#endif

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject dfs_referral_v1_Type;
staticforward PyTypeObject dfs_referral_v2_Type;
staticforward PyTypeObject dfs_normal_referral_Type;
staticforward PyTypeObject dfs_domain_referral_Type;
staticforward PyTypeObject dfs_referral_v3_Type;
staticforward PyTypeObject dfs_referral_v4_Type;
staticforward PyTypeObject dfs_referral_type_Type;
staticforward PyTypeObject dfs_referral_resp_Type;
staticforward PyTypeObject dfsblobs_InterfaceType;


static PyObject *py_dfs_referral_v1_get_size(PyObject *obj, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_dfs_referral_v1_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v1_get_server_type(PyObject *obj, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyInt_FromLong(object->server_type);
	return py_server_type;
}

static int py_dfs_referral_v1_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v1_get_entry_flags(PyObject *obj, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(obj);
	PyObject *py_entry_flags;
	py_entry_flags = PyInt_FromLong(object->entry_flags);
	return py_entry_flags;
}

static int py_dfs_referral_v1_set_entry_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entry_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v1_get_share_name(PyObject *obj, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(obj);
	PyObject *py_share_name;
	py_share_name = PyString_FromString(object->share_name);
	return py_share_name;
}

static int py_dfs_referral_v1_set_share_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v1 *object = (struct dfs_referral_v1 *)py_talloc_get_ptr(py_obj);
	object->share_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyGetSetDef py_dfs_referral_v1_getsetters[] = {
	{ discard_const_p(char, "size"), py_dfs_referral_v1_get_size, py_dfs_referral_v1_set_size },
	{ discard_const_p(char, "server_type"), py_dfs_referral_v1_get_server_type, py_dfs_referral_v1_set_server_type },
	{ discard_const_p(char, "entry_flags"), py_dfs_referral_v1_get_entry_flags, py_dfs_referral_v1_set_entry_flags },
	{ discard_const_p(char, "share_name"), py_dfs_referral_v1_get_share_name, py_dfs_referral_v1_set_share_name },
	{ NULL }
};

static PyObject *py_dfs_referral_v1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_referral_v1, type);
}


static PyTypeObject dfs_referral_v1_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_referral_v1",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_referral_v1_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_referral_v1_new,
};


static PyObject *py_dfs_referral_v2_get_size(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_dfs_referral_v2_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v2_get_server_type(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyInt_FromLong(object->server_type);
	return py_server_type;
}

static int py_dfs_referral_v2_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v2_get_entry_flags(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_entry_flags;
	py_entry_flags = PyInt_FromLong(object->entry_flags);
	return py_entry_flags;
}

static int py_dfs_referral_v2_set_entry_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entry_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v2_get_proximity(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_proximity;
	py_proximity = PyInt_FromLong(object->proximity);
	return py_proximity;
}

static int py_dfs_referral_v2_set_proximity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->proximity = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v2_get_ttl(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyInt_FromLong(object->ttl);
	return py_ttl;
}

static int py_dfs_referral_v2_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ttl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v2_get_DFS_path(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_DFS_path;
	py_DFS_path = PyString_FromString(object->DFS_path);
	return py_DFS_path;
}

static int py_dfs_referral_v2_set_DFS_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	object->DFS_path = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_dfs_referral_v2_get_DFS_alt_path(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_DFS_alt_path;
	py_DFS_alt_path = PyString_FromString(object->DFS_alt_path);
	return py_DFS_alt_path;
}

static int py_dfs_referral_v2_set_DFS_alt_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	object->DFS_alt_path = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_dfs_referral_v2_get_netw_address(PyObject *obj, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(obj);
	PyObject *py_netw_address;
	py_netw_address = PyString_FromString(object->netw_address);
	return py_netw_address;
}

static int py_dfs_referral_v2_set_netw_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v2 *object = (struct dfs_referral_v2 *)py_talloc_get_ptr(py_obj);
	object->netw_address = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyGetSetDef py_dfs_referral_v2_getsetters[] = {
	{ discard_const_p(char, "size"), py_dfs_referral_v2_get_size, py_dfs_referral_v2_set_size },
	{ discard_const_p(char, "server_type"), py_dfs_referral_v2_get_server_type, py_dfs_referral_v2_set_server_type },
	{ discard_const_p(char, "entry_flags"), py_dfs_referral_v2_get_entry_flags, py_dfs_referral_v2_set_entry_flags },
	{ discard_const_p(char, "proximity"), py_dfs_referral_v2_get_proximity, py_dfs_referral_v2_set_proximity },
	{ discard_const_p(char, "ttl"), py_dfs_referral_v2_get_ttl, py_dfs_referral_v2_set_ttl },
	{ discard_const_p(char, "DFS_path"), py_dfs_referral_v2_get_DFS_path, py_dfs_referral_v2_set_DFS_path },
	{ discard_const_p(char, "DFS_alt_path"), py_dfs_referral_v2_get_DFS_alt_path, py_dfs_referral_v2_set_DFS_alt_path },
	{ discard_const_p(char, "netw_address"), py_dfs_referral_v2_get_netw_address, py_dfs_referral_v2_set_netw_address },
	{ NULL }
};

static PyObject *py_dfs_referral_v2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_referral_v2, type);
}


static PyTypeObject dfs_referral_v2_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_referral_v2",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_referral_v2_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_referral_v2_new,
};


static PyObject *py_dfs_normal_referral_get_DFS_path(PyObject *obj, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(obj);
	PyObject *py_DFS_path;
	py_DFS_path = PyString_FromString(object->DFS_path);
	return py_DFS_path;
}

static int py_dfs_normal_referral_set_DFS_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(py_obj);
	object->DFS_path = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_dfs_normal_referral_get_DFS_alt_path(PyObject *obj, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(obj);
	PyObject *py_DFS_alt_path;
	py_DFS_alt_path = PyString_FromString(object->DFS_alt_path);
	return py_DFS_alt_path;
}

static int py_dfs_normal_referral_set_DFS_alt_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(py_obj);
	object->DFS_alt_path = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_dfs_normal_referral_get_netw_address(PyObject *obj, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(obj);
	PyObject *py_netw_address;
	py_netw_address = PyString_FromString(object->netw_address);
	return py_netw_address;
}

static int py_dfs_normal_referral_set_netw_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(py_obj);
	object->netw_address = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_dfs_normal_referral_get_service_site_guid(PyObject *obj, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(obj);
	PyObject *py_service_site_guid;
	py_service_site_guid = PyList_New(16);
	if (py_service_site_guid == NULL) {
		return NULL;
	}
	{
		int service_site_guid_cntr_0;
		for (service_site_guid_cntr_0 = 0; service_site_guid_cntr_0 < 16; service_site_guid_cntr_0++) {
			PyObject *py_service_site_guid_0;
			py_service_site_guid_0 = PyInt_FromLong(object->service_site_guid[service_site_guid_cntr_0]);
			PyList_SetItem(py_service_site_guid, service_site_guid_cntr_0, py_service_site_guid_0);
		}
	}
	return py_service_site_guid;
}

static int py_dfs_normal_referral_set_service_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_normal_referral *object = (struct dfs_normal_referral *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int service_site_guid_cntr_0;
		for (service_site_guid_cntr_0 = 0; service_site_guid_cntr_0 < PyList_Size(value); service_site_guid_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, service_site_guid_cntr_0), return -1;);
			object->service_site_guid[service_site_guid_cntr_0] = PyInt_AsLong(PyList_GetItem(value, service_site_guid_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dfs_normal_referral_getsetters[] = {
	{ discard_const_p(char, "DFS_path"), py_dfs_normal_referral_get_DFS_path, py_dfs_normal_referral_set_DFS_path },
	{ discard_const_p(char, "DFS_alt_path"), py_dfs_normal_referral_get_DFS_alt_path, py_dfs_normal_referral_set_DFS_alt_path },
	{ discard_const_p(char, "netw_address"), py_dfs_normal_referral_get_netw_address, py_dfs_normal_referral_set_netw_address },
	{ discard_const_p(char, "service_site_guid"), py_dfs_normal_referral_get_service_site_guid, py_dfs_normal_referral_set_service_site_guid },
	{ NULL }
};

static PyObject *py_dfs_normal_referral_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_normal_referral, type);
}


static PyTypeObject dfs_normal_referral_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_normal_referral",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_normal_referral_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_normal_referral_new,
};


static PyObject *py_dfs_domain_referral_get_special_name(PyObject *obj, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(obj);
	PyObject *py_special_name;
	py_special_name = PyString_FromString(object->special_name);
	return py_special_name;
}

static int py_dfs_domain_referral_set_special_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(py_obj);
	object->special_name = talloc_strdup(py_talloc_get_mem_ctx(py_obj), PyString_AsString(value));
	return 0;
}

static PyObject *py_dfs_domain_referral_get_nb_expanded_names(PyObject *obj, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(obj);
	PyObject *py_nb_expanded_names;
	py_nb_expanded_names = PyInt_FromLong(object->nb_expanded_names);
	return py_nb_expanded_names;
}

static int py_dfs_domain_referral_set_nb_expanded_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nb_expanded_names = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_domain_referral_get_expanded_names(PyObject *obj, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(obj);
	PyObject *py_expanded_names;
	py_expanded_names = PyCObject_FromTallocPtr(object->expanded_names);
	return py_expanded_names;
}

static int py_dfs_domain_referral_set_expanded_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(py_obj);
	object->expanded_names = PyCObject_AsVoidPtr(value);
	return 0;
}

static PyObject *py_dfs_domain_referral_get_service_site_guid(PyObject *obj, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(obj);
	PyObject *py_service_site_guid;
	py_service_site_guid = PyList_New(16);
	if (py_service_site_guid == NULL) {
		return NULL;
	}
	{
		int service_site_guid_cntr_0;
		for (service_site_guid_cntr_0 = 0; service_site_guid_cntr_0 < 16; service_site_guid_cntr_0++) {
			PyObject *py_service_site_guid_0;
			py_service_site_guid_0 = PyInt_FromLong(object->service_site_guid[service_site_guid_cntr_0]);
			PyList_SetItem(py_service_site_guid, service_site_guid_cntr_0, py_service_site_guid_0);
		}
	}
	return py_service_site_guid;
}

static int py_dfs_domain_referral_set_service_site_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_domain_referral *object = (struct dfs_domain_referral *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int service_site_guid_cntr_0;
		for (service_site_guid_cntr_0 = 0; service_site_guid_cntr_0 < PyList_Size(value); service_site_guid_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GetItem(value, service_site_guid_cntr_0), return -1;);
			object->service_site_guid[service_site_guid_cntr_0] = PyInt_AsLong(PyList_GetItem(value, service_site_guid_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dfs_domain_referral_getsetters[] = {
	{ discard_const_p(char, "special_name"), py_dfs_domain_referral_get_special_name, py_dfs_domain_referral_set_special_name },
	{ discard_const_p(char, "nb_expanded_names"), py_dfs_domain_referral_get_nb_expanded_names, py_dfs_domain_referral_set_nb_expanded_names },
	{ discard_const_p(char, "expanded_names"), py_dfs_domain_referral_get_expanded_names, py_dfs_domain_referral_set_expanded_names },
	{ discard_const_p(char, "service_site_guid"), py_dfs_domain_referral_get_service_site_guid, py_dfs_domain_referral_set_service_site_guid },
	{ NULL }
};

static PyObject *py_dfs_domain_referral_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_domain_referral, type);
}


static PyTypeObject dfs_domain_referral_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_domain_referral",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_domain_referral_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_domain_referral_new,
};

PyObject *py_import_dfs_referral(TALLOC_CTX *mem_ctx, int level, union dfs_referral *in)
{
	PyObject *ret;

	switch (level) {
		case 0:
			ret = py_talloc_reference_ex(&dfs_normal_referral_Type, mem_ctx, &in->r1);
			return ret;

		case 2:
			ret = py_talloc_reference_ex(&dfs_domain_referral_Type, mem_ctx, &in->r2);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dfs_referral *py_export_dfs_referral(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dfs_referral *ret = talloc_zero(mem_ctx, union dfs_referral);
	switch (level) {
		case 0:
			PY_CHECK_TYPE(&dfs_normal_referral_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->r1, py_talloc_get_ptr(in), sizeof(ret->r1));
			break;

		case 2:
			PY_CHECK_TYPE(&dfs_domain_referral_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->r2, py_talloc_get_ptr(in), sizeof(ret->r2));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_dfs_referral_v3_get_size(PyObject *obj, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_dfs_referral_v3_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v3_get_server_type(PyObject *obj, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyInt_FromLong(object->server_type);
	return py_server_type;
}

static int py_dfs_referral_v3_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v3_get_entry_flags(PyObject *obj, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(obj);
	PyObject *py_entry_flags;
	py_entry_flags = PyInt_FromLong(object->entry_flags);
	return py_entry_flags;
}

static int py_dfs_referral_v3_set_entry_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entry_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v3_get_ttl(PyObject *obj, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyInt_FromLong(object->ttl);
	return py_ttl;
}

static int py_dfs_referral_v3_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ttl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v3_get_referrals(PyObject *obj, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(obj);
	PyObject *py_referrals;
	py_referrals = py_import_dfs_referral(py_talloc_get_mem_ctx(obj), object->entry_flags & DFS_FLAG_REFERRAL_DOMAIN_RESP, &object->referrals);
	if (py_referrals == NULL) {
		return NULL;
	}
	return py_referrals;
}

static int py_dfs_referral_v3_set_referrals(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v3 *object = (struct dfs_referral_v3 *)py_talloc_get_ptr(py_obj);
	memcpy(&object->referrals, py_export_dfs_referral(py_talloc_get_mem_ctx(py_obj), object->entry_flags & DFS_FLAG_REFERRAL_DOMAIN_RESP, value), sizeof(object->referrals));
	return 0;
}

static PyGetSetDef py_dfs_referral_v3_getsetters[] = {
	{ discard_const_p(char, "size"), py_dfs_referral_v3_get_size, py_dfs_referral_v3_set_size },
	{ discard_const_p(char, "server_type"), py_dfs_referral_v3_get_server_type, py_dfs_referral_v3_set_server_type },
	{ discard_const_p(char, "entry_flags"), py_dfs_referral_v3_get_entry_flags, py_dfs_referral_v3_set_entry_flags },
	{ discard_const_p(char, "ttl"), py_dfs_referral_v3_get_ttl, py_dfs_referral_v3_set_ttl },
	{ discard_const_p(char, "referrals"), py_dfs_referral_v3_get_referrals, py_dfs_referral_v3_set_referrals },
	{ NULL }
};

static PyObject *py_dfs_referral_v3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_referral_v3, type);
}


static PyTypeObject dfs_referral_v3_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_referral_v3",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_referral_v3_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_referral_v3_new,
};


static PyObject *py_dfs_referral_v4_get_size(PyObject *obj, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyInt_FromLong(object->size);
	return py_size;
}

static int py_dfs_referral_v4_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v4_get_server_type(PyObject *obj, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(obj);
	PyObject *py_server_type;
	py_server_type = PyInt_FromLong(object->server_type);
	return py_server_type;
}

static int py_dfs_referral_v4_set_server_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->server_type = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v4_get_entry_flags(PyObject *obj, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(obj);
	PyObject *py_entry_flags;
	py_entry_flags = PyInt_FromLong(object->entry_flags);
	return py_entry_flags;
}

static int py_dfs_referral_v4_set_entry_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->entry_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v4_get_ttl(PyObject *obj, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(obj);
	PyObject *py_ttl;
	py_ttl = PyInt_FromLong(object->ttl);
	return py_ttl;
}

static int py_dfs_referral_v4_set_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->ttl = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_v4_get_referrals(PyObject *obj, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(obj);
	PyObject *py_referrals;
	py_referrals = py_talloc_reference_ex(&dfs_normal_referral_Type, py_talloc_get_mem_ctx(obj), &object->referrals);
	return py_referrals;
}

static int py_dfs_referral_v4_set_referrals(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_v4 *object = (struct dfs_referral_v4 *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&dfs_normal_referral_Type, value, return -1;);
	memcpy(&object->referrals, py_talloc_get_ptr(value), sizeof(object->referrals));
	return 0;
}

static PyGetSetDef py_dfs_referral_v4_getsetters[] = {
	{ discard_const_p(char, "size"), py_dfs_referral_v4_get_size, py_dfs_referral_v4_set_size },
	{ discard_const_p(char, "server_type"), py_dfs_referral_v4_get_server_type, py_dfs_referral_v4_set_server_type },
	{ discard_const_p(char, "entry_flags"), py_dfs_referral_v4_get_entry_flags, py_dfs_referral_v4_set_entry_flags },
	{ discard_const_p(char, "ttl"), py_dfs_referral_v4_get_ttl, py_dfs_referral_v4_set_ttl },
	{ discard_const_p(char, "referrals"), py_dfs_referral_v4_get_referrals, py_dfs_referral_v4_set_referrals },
	{ NULL }
};

static PyObject *py_dfs_referral_v4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_referral_v4, type);
}


static PyTypeObject dfs_referral_v4_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_referral_v4",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_referral_v4_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_referral_v4_new,
};

PyObject *py_import_dfs_referral_version(TALLOC_CTX *mem_ctx, int level, union dfs_referral_version *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = py_talloc_reference_ex(&dfs_referral_v1_Type, mem_ctx, &in->v1);
			return ret;

		case 2:
			ret = py_talloc_reference_ex(&dfs_referral_v2_Type, mem_ctx, &in->v2);
			return ret;

		case 3:
			ret = py_talloc_reference_ex(&dfs_referral_v3_Type, mem_ctx, &in->v3);
			return ret;

		case 4:
			ret = py_talloc_reference_ex(&dfs_referral_v4_Type, mem_ctx, &in->v4);
			return ret;

		default:
			ret = Py_None;
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union dfs_referral_version *py_export_dfs_referral_version(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dfs_referral_version *ret = talloc_zero(mem_ctx, union dfs_referral_version);
	switch (level) {
		case 1:
			PY_CHECK_TYPE(&dfs_referral_v1_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v1, py_talloc_get_ptr(in), sizeof(ret->v1));
			break;

		case 2:
			PY_CHECK_TYPE(&dfs_referral_v2_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v2, py_talloc_get_ptr(in), sizeof(ret->v2));
			break;

		case 3:
			PY_CHECK_TYPE(&dfs_referral_v3_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v3, py_talloc_get_ptr(in), sizeof(ret->v3));
			break;

		case 4:
			PY_CHECK_TYPE(&dfs_referral_v4_Type, in, talloc_free(ret); return NULL;);
			memcpy(&ret->v4, py_talloc_get_ptr(in), sizeof(ret->v4));
			break;

		default:
			break;

	}

	return ret;
}


static PyObject *py_dfs_referral_type_get_version(PyObject *obj, void *closure)
{
	struct dfs_referral_type *object = (struct dfs_referral_type *)py_talloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyInt_FromLong(object->version);
	return py_version;
}

static int py_dfs_referral_type_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_type *object = (struct dfs_referral_type *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_type_get_referral(PyObject *obj, void *closure)
{
	struct dfs_referral_type *object = (struct dfs_referral_type *)py_talloc_get_ptr(obj);
	PyObject *py_referral;
	py_referral = py_import_dfs_referral_version(py_talloc_get_mem_ctx(obj), object->version, &object->referral);
	if (py_referral == NULL) {
		return NULL;
	}
	return py_referral;
}

static int py_dfs_referral_type_set_referral(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_type *object = (struct dfs_referral_type *)py_talloc_get_ptr(py_obj);
	memcpy(&object->referral, py_export_dfs_referral_version(py_talloc_get_mem_ctx(py_obj), object->version, value), sizeof(object->referral));
	return 0;
}

static PyGetSetDef py_dfs_referral_type_getsetters[] = {
	{ discard_const_p(char, "version"), py_dfs_referral_type_get_version, py_dfs_referral_type_set_version },
	{ discard_const_p(char, "referral"), py_dfs_referral_type_get_referral, py_dfs_referral_type_set_referral },
	{ NULL }
};

static PyObject *py_dfs_referral_type_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_referral_type, type);
}


static PyTypeObject dfs_referral_type_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_referral_type",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_referral_type_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_referral_type_new,
};


static PyObject *py_dfs_referral_resp_get_path_consumed(PyObject *obj, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(obj);
	PyObject *py_path_consumed;
	py_path_consumed = PyInt_FromLong(object->path_consumed);
	return py_path_consumed;
}

static int py_dfs_referral_resp_set_path_consumed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->path_consumed = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_resp_get_nb_referrals(PyObject *obj, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(obj);
	PyObject *py_nb_referrals;
	py_nb_referrals = PyInt_FromLong(object->nb_referrals);
	return py_nb_referrals;
}

static int py_dfs_referral_resp_set_nb_referrals(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->nb_referrals = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_resp_get_header_flags(PyObject *obj, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(obj);
	PyObject *py_header_flags;
	py_header_flags = PyInt_FromLong(object->header_flags);
	return py_header_flags;
}

static int py_dfs_referral_resp_set_header_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->header_flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_dfs_referral_resp_get_referral_entries(PyObject *obj, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(obj);
	PyObject *py_referral_entries;
	py_referral_entries = PyList_New(object->nb_referrals);
	if (py_referral_entries == NULL) {
		return NULL;
	}
	{
		int referral_entries_cntr_0;
		for (referral_entries_cntr_0 = 0; referral_entries_cntr_0 < object->nb_referrals; referral_entries_cntr_0++) {
			PyObject *py_referral_entries_0;
			py_referral_entries_0 = py_talloc_reference_ex(&dfs_referral_type_Type, object->referral_entries, &object->referral_entries[referral_entries_cntr_0]);
			PyList_SetItem(py_referral_entries, referral_entries_cntr_0, py_referral_entries_0);
		}
	}
	return py_referral_entries;
}

static int py_dfs_referral_resp_set_referral_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int referral_entries_cntr_0;
		object->referral_entries = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->referral_entries, PyList_Size(value));
		for (referral_entries_cntr_0 = 0; referral_entries_cntr_0 < PyList_Size(value); referral_entries_cntr_0++) {
			PY_CHECK_TYPE(&dfs_referral_type_Type, PyList_GetItem(value, referral_entries_cntr_0), return -1;);
			memcpy(&object->referral_entries[referral_entries_cntr_0], py_talloc_get_ptr(PyList_GetItem(value, referral_entries_cntr_0)), sizeof(object->referral_entries[referral_entries_cntr_0]));
		}
	}
	return 0;
}

static PyGetSetDef py_dfs_referral_resp_getsetters[] = {
	{ discard_const_p(char, "path_consumed"), py_dfs_referral_resp_get_path_consumed, py_dfs_referral_resp_set_path_consumed },
	{ discard_const_p(char, "nb_referrals"), py_dfs_referral_resp_get_nb_referrals, py_dfs_referral_resp_set_nb_referrals },
	{ discard_const_p(char, "header_flags"), py_dfs_referral_resp_get_header_flags, py_dfs_referral_resp_set_header_flags },
	{ discard_const_p(char, "referral_entries"), py_dfs_referral_resp_get_referral_entries, py_dfs_referral_resp_set_referral_entries },
	{ NULL }
};

static PyObject *py_dfs_referral_resp_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct dfs_referral_resp, type);
}

static PyObject *py_dfs_referral_resp_ndr_pack(PyObject *py_obj)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	err = ndr_push_struct_blob(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_push_flags_fn_t)ndr_push_dfs_referral_resp);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	return PyString_FromStringAndSize((char *)blob.data, blob.length);
}

static PyObject *py_dfs_referral_resp_ndr_unpack(PyObject *py_obj, PyObject *args)
{
	struct dfs_referral_resp *object = (struct dfs_referral_resp *)py_talloc_get_ptr(py_obj);
	DATA_BLOB blob;
	enum ndr_err_code err;
	if (!PyArg_ParseTuple(args, "s#:__ndr_unpack__", &blob.data, &blob.length))
		return NULL;

	err = ndr_pull_struct_blob_all(&blob, py_talloc_get_mem_ctx(py_obj), NULL, object, (ndr_pull_flags_fn_t)ndr_pull_dfs_referral_resp);
	if (err != NDR_ERR_SUCCESS) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyMethodDef py_dfs_referral_resp_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dfs_referral_resp_ndr_pack, METH_NOARGS, "S.pack() -> blob\nNDR pack" },
	{ "__ndr_unpack__", (PyCFunction)py_dfs_referral_resp_ndr_unpack, METH_VARARGS, "S.unpack(blob) -> None\nNDR unpack" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dfs_referral_resp_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfs_referral_resp",
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_dealloc = py_talloc_dealloc,
	.tp_getset = py_dfs_referral_resp_getsetters,
	.tp_repr = py_talloc_default_repr,
	.tp_methods = py_dfs_referral_resp_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dfs_referral_resp_new,
};


static bool pack_py_dfs_GetDFSReferral_args_in(PyObject *args, PyObject *kwargs, struct dfs_GetDFSReferral *r)
{
	PyObject *py_max_referral_level;
	PyObject *py_servername;
	const char *kwnames[] = {
		"max_referral_level", "servername", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:dfs_GetDFSReferral", discard_const_p(char *, kwnames), &py_max_referral_level, &py_servername)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_max_referral_level, return false;);
	r->in.max_referral_level = PyInt_AsLong(py_max_referral_level);
	r->in.servername = talloc_strdup(r, PyString_AsString(py_servername));
	return true;
}

static PyObject *unpack_py_dfs_GetDFSReferral_args_out(struct dfs_GetDFSReferral *r)
{
	PyObject *result = Py_None;
	PyObject *py_resp;
	py_resp = py_talloc_reference_ex(&dfs_referral_resp_Type, r->out.resp, r->out.resp);
	result = py_resp;
	return result;
}

const struct PyNdrRpcMethodDef py_ndr_dfsblobs_methods[] = {
	{ "dfs_GetDFSReferral", "S.dfs_GetDFSReferral(max_referral_level, servername) -> resp", (dcerpc_call_fn)dcerpc_dfs_GetDFSReferral, (py_data_pack_fn)pack_py_dfs_GetDFSReferral_args_in, (py_data_unpack_fn)unpack_py_dfs_GetDFSReferral_args_out, 0, &ndr_table_dfsblobs },
	{ NULL }
};

static PyObject *interface_dfsblobs_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_dfsblobs);
}

#define PY_DOC_DFSBLOBS "dfs referral blobs"
static PyTypeObject dfsblobs_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "dfsblobs.dfsblobs",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_base = &dcerpc_InterfaceType,
	.tp_doc = "dfsblobs(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_DFSBLOBS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_dfsblobs_new,
};

static PyMethodDef dfsblobs_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initdfsblobs(void)
{
	PyObject *m;
	PyObject *dep_misc;

	dep_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_misc == NULL)
		return;

	if (PyType_Ready(&dfs_referral_v1_Type) < 0)
		return;
	if (PyType_Ready(&dfs_referral_v2_Type) < 0)
		return;
	if (PyType_Ready(&dfs_normal_referral_Type) < 0)
		return;
	if (PyType_Ready(&dfs_domain_referral_Type) < 0)
		return;
	if (PyType_Ready(&dfs_referral_v3_Type) < 0)
		return;
	if (PyType_Ready(&dfs_referral_v4_Type) < 0)
		return;
	if (PyType_Ready(&dfs_referral_type_Type) < 0)
		return;
	if (PyType_Ready(&dfs_referral_resp_Type) < 0)
		return;
	if (PyType_Ready(&dfsblobs_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&dfsblobs_InterfaceType, py_ndr_dfsblobs_methods))
		return;

#ifdef PY_DFS_REFERRAL_V1_PATCH
	PY_DFS_REFERRAL_V1_PATCH(&dfs_referral_v1_Type);
#endif
#ifdef PY_DFS_REFERRAL_V2_PATCH
	PY_DFS_REFERRAL_V2_PATCH(&dfs_referral_v2_Type);
#endif
#ifdef PY_DFS_NORMAL_REFERRAL_PATCH
	PY_DFS_NORMAL_REFERRAL_PATCH(&dfs_normal_referral_Type);
#endif
#ifdef PY_DFS_DOMAIN_REFERRAL_PATCH
	PY_DFS_DOMAIN_REFERRAL_PATCH(&dfs_domain_referral_Type);
#endif
#ifdef PY_DFS_REFERRAL_V3_PATCH
	PY_DFS_REFERRAL_V3_PATCH(&dfs_referral_v3_Type);
#endif
#ifdef PY_DFS_REFERRAL_V4_PATCH
	PY_DFS_REFERRAL_V4_PATCH(&dfs_referral_v4_Type);
#endif
#ifdef PY_DFS_REFERRAL_TYPE_PATCH
	PY_DFS_REFERRAL_TYPE_PATCH(&dfs_referral_type_Type);
#endif
#ifdef PY_DFS_REFERRAL_RESP_PATCH
	PY_DFS_REFERRAL_RESP_PATCH(&dfs_referral_resp_Type);
#endif
#ifdef PY_DFSBLOBS_PATCH
	PY_DFSBLOBS_PATCH(&dfsblobs_InterfaceType);
#endif

	m = Py_InitModule3("dfsblobs", dfsblobs_methods, "dfsblobs DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "DFS_SERVER_ROOT", PyInt_FromLong(DFS_SERVER_ROOT));
	PyModule_AddObject(m, "DFS_SERVER_NON_ROOT", PyInt_FromLong(DFS_SERVER_NON_ROOT));
	PyModule_AddObject(m, "DFS_HEADER_FLAG_TARGET_BCK", PyInt_FromLong(DFS_HEADER_FLAG_TARGET_BCK));
	PyModule_AddObject(m, "DFS_FLAG_REFERRAL_DOMAIN_RESP", PyInt_FromLong(DFS_FLAG_REFERRAL_DOMAIN_RESP));
	PyModule_AddObject(m, "DFS_FLAG_REFERRAL_FIRST_TARGET_SET", PyInt_FromLong(DFS_FLAG_REFERRAL_FIRST_TARGET_SET));
	PyModule_AddObject(m, "DFS_HEADER_FLAG_STORAGE_SVR", PyInt_FromLong(DFS_HEADER_FLAG_STORAGE_SVR));
	PyModule_AddObject(m, "DFS_HEADER_FLAG_REFERAL_SVR", PyInt_FromLong(DFS_HEADER_FLAG_REFERAL_SVR));
	Py_INCREF((PyObject *)&dfs_referral_v1_Type);
	PyModule_AddObject(m, "dfs_referral_v1", (PyObject *)&dfs_referral_v1_Type);
	Py_INCREF((PyObject *)&dfs_referral_v2_Type);
	PyModule_AddObject(m, "dfs_referral_v2", (PyObject *)&dfs_referral_v2_Type);
	Py_INCREF((PyObject *)&dfs_normal_referral_Type);
	PyModule_AddObject(m, "dfs_normal_referral", (PyObject *)&dfs_normal_referral_Type);
	Py_INCREF((PyObject *)&dfs_domain_referral_Type);
	PyModule_AddObject(m, "dfs_domain_referral", (PyObject *)&dfs_domain_referral_Type);
	Py_INCREF((PyObject *)&dfs_referral_v3_Type);
	PyModule_AddObject(m, "dfs_referral_v3", (PyObject *)&dfs_referral_v3_Type);
	Py_INCREF((PyObject *)&dfs_referral_v4_Type);
	PyModule_AddObject(m, "dfs_referral_v4", (PyObject *)&dfs_referral_v4_Type);
	Py_INCREF((PyObject *)&dfs_referral_type_Type);
	PyModule_AddObject(m, "dfs_referral_type", (PyObject *)&dfs_referral_type_Type);
	Py_INCREF((PyObject *)&dfs_referral_resp_Type);
	PyModule_AddObject(m, "dfs_referral_resp", (PyObject *)&dfs_referral_resp_Type);
	Py_INCREF((PyObject *)&dfsblobs_InterfaceType);
	PyModule_AddObject(m, "dfsblobs", (PyObject *)&dfsblobs_InterfaceType);
#ifdef PY_MOD_DFSBLOBS_PATCH
	PY_MOD_DFSBLOBS_PATCH(m);
#endif

}
