/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_unixinfo.h"

struct rpccli_unixinfo_SidToUid_state {
	struct unixinfo_SidToUid orig;
	struct unixinfo_SidToUid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_unixinfo_SidToUid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_unixinfo_SidToUid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct dom_sid _sid /* [in]  */,
						 uint64_t *_uid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_unixinfo_SidToUid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_unixinfo_SidToUid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.uid = _uid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_unixinfo_SidToUid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_unixinfo,
				    NDR_UNIXINFO_SIDTOUID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_unixinfo_SidToUid_done, req);
	return req;
}

static void rpccli_unixinfo_SidToUid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_unixinfo_SidToUid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_SidToUid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.uid = *state->tmp.out.uid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_unixinfo_SidToUid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_unixinfo_SidToUid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_SidToUid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_unixinfo_SidToUid(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct dom_sid sid /* [in]  */,
				  uint64_t *uid /* [out] [ref] */)
{
	struct unixinfo_SidToUid r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_unixinfo,
				NDR_UNIXINFO_SIDTOUID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*uid = *r.out.uid;

	/* Return result */
	return r.out.result;
}

struct rpccli_unixinfo_UidToSid_state {
	struct unixinfo_UidToSid orig;
	struct unixinfo_UidToSid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_unixinfo_UidToSid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_unixinfo_UidToSid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 uint64_t _uid /* [in]  */,
						 struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_unixinfo_UidToSid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_unixinfo_UidToSid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.uid = _uid;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_unixinfo_UidToSid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_unixinfo,
				    NDR_UNIXINFO_UIDTOSID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_unixinfo_UidToSid_done, req);
	return req;
}

static void rpccli_unixinfo_UidToSid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_unixinfo_UidToSid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_UidToSid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_unixinfo_UidToSid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_unixinfo_UidToSid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_UidToSid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_unixinfo_UidToSid(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  uint64_t uid /* [in]  */,
				  struct dom_sid *sid /* [out] [ref] */)
{
	struct unixinfo_UidToSid r;
	NTSTATUS status;

	/* In parameters */
	r.in.uid = uid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_unixinfo,
				NDR_UNIXINFO_UIDTOSID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sid = *r.out.sid;

	/* Return result */
	return r.out.result;
}

struct rpccli_unixinfo_SidToGid_state {
	struct unixinfo_SidToGid orig;
	struct unixinfo_SidToGid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_unixinfo_SidToGid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_unixinfo_SidToGid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 struct dom_sid _sid /* [in]  */,
						 uint64_t *_gid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_unixinfo_SidToGid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_unixinfo_SidToGid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.sid = _sid;

	/* Out parameters */
	state->orig.out.gid = _gid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_unixinfo_SidToGid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_unixinfo,
				    NDR_UNIXINFO_SIDTOGID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_unixinfo_SidToGid_done, req);
	return req;
}

static void rpccli_unixinfo_SidToGid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_unixinfo_SidToGid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_SidToGid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gid = *state->tmp.out.gid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_unixinfo_SidToGid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_unixinfo_SidToGid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_SidToGid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_unixinfo_SidToGid(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct dom_sid sid /* [in]  */,
				  uint64_t *gid /* [out] [ref] */)
{
	struct unixinfo_SidToGid r;
	NTSTATUS status;

	/* In parameters */
	r.in.sid = sid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_unixinfo,
				NDR_UNIXINFO_SIDTOGID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*gid = *r.out.gid;

	/* Return result */
	return r.out.result;
}

struct rpccli_unixinfo_GidToSid_state {
	struct unixinfo_GidToSid orig;
	struct unixinfo_GidToSid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_unixinfo_GidToSid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_unixinfo_GidToSid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 uint64_t _gid /* [in]  */,
						 struct dom_sid *_sid /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_unixinfo_GidToSid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_unixinfo_GidToSid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.gid = _gid;

	/* Out parameters */
	state->orig.out.sid = _sid;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_unixinfo_GidToSid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_unixinfo,
				    NDR_UNIXINFO_GIDTOSID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_unixinfo_GidToSid_done, req);
	return req;
}

static void rpccli_unixinfo_GidToSid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_unixinfo_GidToSid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_GidToSid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.sid = *state->tmp.out.sid;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_unixinfo_GidToSid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_unixinfo_GidToSid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_GidToSid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_unixinfo_GidToSid(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  uint64_t gid /* [in]  */,
				  struct dom_sid *sid /* [out] [ref] */)
{
	struct unixinfo_GidToSid r;
	NTSTATUS status;

	/* In parameters */
	r.in.gid = gid;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_unixinfo,
				NDR_UNIXINFO_GIDTOSID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sid = *r.out.sid;

	/* Return result */
	return r.out.result;
}

struct rpccli_unixinfo_GetPWUid_state {
	struct unixinfo_GetPWUid orig;
	struct unixinfo_GetPWUid tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_unixinfo_GetPWUid_done(struct tevent_req *subreq);

struct tevent_req *rpccli_unixinfo_GetPWUid_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct rpc_pipe_client *cli,
						 uint32_t *_count /* [in,out] [ref,range(0,1023)] */,
						 uint64_t *_uids /* [in] [size_is(*count)] */,
						 struct unixinfo_GetPWUidInfo *_infos /* [out] [size_is(*count)] */)
{
	struct tevent_req *req;
	struct rpccli_unixinfo_GetPWUid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_unixinfo_GetPWUid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.count = _count;
	state->orig.in.uids = _uids;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.infos = _infos;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_unixinfo_GetPWUid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_unixinfo,
				    NDR_UNIXINFO_GETPWUID,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_unixinfo_GetPWUid_done, req);
	return req;
}

static void rpccli_unixinfo_GetPWUid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_unixinfo_GetPWUid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_GetPWUid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	memcpy(state->orig.out.infos, state->tmp.out.infos, (*state->tmp.in.count) * sizeof(*state->orig.out.infos));

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS rpccli_unixinfo_GetPWUid_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       NTSTATUS *result)
{
	struct rpccli_unixinfo_GetPWUid_state *state = tevent_req_data(
		req, struct rpccli_unixinfo_GetPWUid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_unixinfo_GetPWUid(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  uint32_t *count /* [in,out] [ref,range(0,1023)] */,
				  uint64_t *uids /* [in] [size_is(*count)] */,
				  struct unixinfo_GetPWUidInfo *infos /* [out] [size_is(*count)] */)
{
	struct unixinfo_GetPWUid r;
	NTSTATUS status;

	/* In parameters */
	r.in.count = count;
	r.in.uids = uids;

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_unixinfo,
				NDR_UNIXINFO_GETPWUID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*count = *r.out.count;
	memcpy(infos, r.out.infos, (*r.in.count) * sizeof(*infos));

	/* Return result */
	return r.out.result;
}

