# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "mp3info"
require File.join(File.dirname(__FILE__), "read-buckets-to-file")

class AudioMpeg
  SUPPORTED_VERSION = 1
  MIME_TYPE = "audio/mpeg"

  include ReadBucketsToFile

  private

  def process_file(filter, mime_type, path)
    file_encoding = nil
    db_encoding = filter.db_encoding
    info = Mp3Info.open(path)
    tag = info.tag

    if tag && !tag.empty?
      text = ""

      properties = ["title", "artist", "album"]
      properties.each do |name|
        value = tag[name]
        if !value.empty?
          text.concat(name + ": " + value + "\n")
        end
      end
      
      comments = tag["comments"]
      if !comments.empty?
        if (match_data = /\000+(.*)/.match(comments))
          text.concat("comments: " + match_data[1] + "\n")
        end
      end

      file_encoding = Rast::EncodingConverter.guess(text,
                                                    Rast::JAPANESE_ENCODINGS)
      s = Rast::EncodingConverter.convert_encoding(file_encoding, db_encoding,
                                                   text)
      bucket = Rast::TransientBucket.new(s)
      next_brigade = Rast::Brigade.new
      next_brigade.insert_tail(bucket)
      next_brigade.insert_tail(Rast::EOSBucket.new)
      filter.pass(next_brigade, "text/plain")
      tag.each do |name, value|
        s = value
        if value
          s = Rast::EncodingConverter.convert_encoding(file_encoding,
                                                       db_encoding, value.to_s)
          if !s.empty?
            case name
            when "artist"
              filter.set_property(name, s)
              filter.set_property("author", s)
            when "comments"
              if (match_data = /\000+(.*)/.match(s))
                filter.set_property(name, match_data[1])
              end
            when "year", "tracknum"
              filter.set_property(name, s.to_i)
            when "genre_s"
              if (match_data = /\((.*?)\)(.*)?/.match(s))
                filter.set_property("genre_id", match_data[1].to_i)
                if match_data[2].empty?
                  filter.set_property("genre",
                                      Mp3Info::GENRES[match_data[1].to_i])
                else
                  filter.set_property("genre", match_data[2])
                end
              end
            else
              filter.set_property(name, s)
            end
          end
        end
      end
    end
  end
end
