/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RAST_QUERY_H
#define RAST_QUERY_H

#include <apr_pools.h>
#include <apr_ring.h>

#include "rast/encoding.h"
#include "rast/result.h"
#include "rast/local_db.h"

typedef struct rast_query_t rast_query_t;

typedef struct {
    rast_score_method_e score_method;
} rast_query_option_t;

typedef struct {
    char *(*inspect)(rast_query_t *query, apr_pool_t *pool);
    rast_error_t *(*exec)(rast_query_t *query,
                          rast_local_db_t *db, rast_query_option_t *options,
                          rast_query_result_t **result, apr_pool_t *pool);
    rast_error_t *(*optimize)(rast_query_t *query,
                              rast_query_t **optimized_query,
                              apr_pool_t *pool);
} rast_query_type_t;

struct rast_query_t {
    rast_query_type_t *type;
    APR_RING_ENTRY(rast_query_t) link;
};

APR_RING_HEAD(rast_query_ring_t, rast_query_t);
typedef struct rast_query_ring_t rast_query_ring_t;

rast_error_t *rast_parse_query(apr_pool_t *pool,
                               rast_encoding_module_t *encoding_module,
                               const char *s, rast_query_t **query);
int rast_query_is_null(rast_query_t *query);
char *rast_query_inspect(rast_query_t *query, apr_pool_t *pool);
rast_error_t *rast_query_exec(rast_query_t *query,
                              rast_local_db_t *db,
                              rast_query_option_t *options,
                              rast_query_result_t **result, apr_pool_t *pool);
rast_error_t *rast_query_optimize(rast_query_t *query,
                                  rast_query_t **optimized_query,
                                  apr_pool_t *pool);

rast_query_result_t *rast_query_result_create(apr_pool_t *pool);

#endif

/* vim: set filetype=c sw=4 expandtab : */
