/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "componentview.h"

#include <qpainter.h>
//Added by qt3to4:
#include <QMouseEvent>
#include <QResizeEvent>
#include <QScrollBar>
#include <QPalette>
#include "complib.h"
#include "xbsch.h"
#include "drawcomponentbase.h"

//󥹥ȥ饯
SComponentWidget::SComponentWidget(QWidget* parent):QWidget (parent)
{
//	m_bLcoMode = lcomode;
	m_block = 0;
	m_pComponentIndex = NULL;
	m_cursorLTRB = -1;
	m_cursorOffset = -1;
	
	QPalette palette;
	palette.setColor(QPalette::Window,Qt::white);
	setPalette(palette);
	//m_drawframe = false;
	//viewport()->setBackgroundColor(QColor("white"));
	setMouseTracking(true);
}

//ǥȥ饯
SComponentWidget::~SComponentWidget()
{
}

QSize SComponentWidget::getContentsSize()
{
	int width;
	int height;
	if(!m_pComponentIndex){
		width = 0;
		height = 0;
	}else{
		width  = m_pComponentIndex->size().w()*10;
		height = m_pComponentIndex->size().h()*10;
	}
	return QSize(width+80,height+80);
}

void SComponentWidget::setComponentIndex(const SCompIndex* pComponentIndex)
{
	m_cursorLTRB = -1;
	m_cursorOffset = -1;
	m_pComponentIndex = pComponentIndex;
	QSize size = getContentsSize();
	resize(size.width(),size.height());
	update();
}

void SComponentWidget::setBlock(int block)
{
	if(!m_pComponentIndex) return;
	if(m_pComponentIndex->block() <= block) return;
	m_block = block;
	update();
}



void  SComponentWidget::paintEvent ( QPaintEvent * event )
{
	QRect rcClip = event->rect();
	QPainter painter(this);

	painter.eraseRect(rcClip);
	SRect srcClip(rcClip.x(),rcClip.y(),rcClip.width(),rcClip.height());
	if(!m_pComponentIndex) return;
	int w = width();
	int h = height();
	SSize size(0,0);

	g_drawComponentBase(&painter,
						 m_pComponentIndex,
						 SPoint(w-40,h-40),
						 size,//compIndex NULLΤȤȤ
						 0,
						 m_block,
						 DRAW_ON,
						 &srcClip,
						 1,
						 true);	
}

void SComponentWidget::resizeEvent(QResizeEvent * )
{
//	qDebug("viewportResizeEvent");
}

void SComponentWidget::mousePressEvent( QMouseEvent * event )
{
	qDebug("SComponentWidget::mousePressEvent X=%d,Y=%d",event->x(),event->y());
}



#if 0
//-----------------------------------------------------------------------------------------
//󥹥ȥ饯
SComponentView::SComponentView(QWidget* parent,bool lcomode):QScrollArea (parent)
{
	m_bLcoMode = lcomode;
	m_block = 0;
	m_pComponentIndex = NULL;
	m_cursorLTRB = -1;
	m_cursorOffset = -1;
	//m_drawframe = false;
	viewport()->setBackgroundColor(QColor("white"));
	viewport()->setMouseTracking(true);
	//˥Сɽ
	setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
	setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOn);
	QSize size = getContentsSize();
	//viewport()->resize(size.width(),size.height());
	resizeContents(size.width(),size.height());
}

//ǥȥ饯
SComponentView::~SComponentView()
{
}

void SComponentView::setComponentIndex(const SCompIndex* pComponentIndex)
{
	m_cursorLTRB = -1;
	m_cursorOffset = -1;
	m_pComponentIndex = pComponentIndex;
	QSize size = getContentsSize();
	resizeContents(size.width(),size.height());
	RefreshView();
}

void SComponentView::setBlock(int block)
{
	if(!m_pComponentIndex) return;
	if(m_pComponentIndex->block() <= block) return;
	m_block = block;
	RefreshView();
}

//ӥ塼ΥƥĤΥ
QSize SComponentView::getContentsSize()
{
	int width;
	int height;
	if(!m_pComponentIndex){
		width = 0;
		height = 0;
	}else{
		width  = m_pComponentIndex->size().w()*10;
		height = m_pComponentIndex->size().h()*10;
	}
	return QSize(width+80,height+80);
}

//LTRBOffsetǼɸºݤΥԥüɸ
SPoint SComponentView::pinEndPos(int ltrb,int offset)
{
	SSize size=m_pComponentIndex->sizePlace(0);
	int l,t,r,b;
	
	r=contentsWidth()-40;
	b=contentsHeight()-40;
	l=r-size.w();
	t=b-size.h();
	int x=0;
	int y=0;
	switch(ltrb){
	case 0:	//L
		x=l-PIN_LENGTH;
		y=t+10*offset;
		break;
	case 1:	//T
		x=l+10*offset;
		y=t-PIN_LENGTH;
		break;
	case 2:	//R
		x=r+PIN_LENGTH;
		y=t+10*offset;
		break;
	case 3:	//B
		x=l+10*offset;
		y=b+PIN_LENGTH;
		break;
	}
	return SPoint(x,y);
}


void  SComponentView::paintEvent ( QPaintEvent * event )
{
	QPainter painter(viewport());
	QRect rcClip = event->rect();
	drawContents(&painter,rcClip.x(),rcClip.y(),rcClip.width(),rcClip.height());
}


//
void SComponentView::drawContents(QPainter*p,int clipx,int clipy, int clipw, int cliph )
{
	p->eraseRect(clipx,clipy,clipw,cliph);
	SRect rcClip(clipx,clipy,clipw,cliph);
	if(!m_pComponentIndex) return;
	int w = contentsWidth();
	int h = contentsHeight();
	SSize size(0,0);

	if(m_bLcoMode){
		drawFrame(p,&rcClip);
	}
	g_drawComponentBase(p,
						 m_pComponentIndex,
						 SPoint(w-40,h-40),
						 size,//compIndex NULLΤȤȤ
						 0,
						 m_block,
						 DRAW_ON,
						 &rcClip,
						 1,
						 true);
	//
	drawCursor(p,&rcClip);
}

void SComponentView::resizeEvent(QResizeEvent * )
{
//	qDebug("viewportResizeEvent");
}

void SComponentView::mousePressEvent(QMouseEvent* me)
{
	if(!m_bLcoMode) return;
	if(m_pComponentIndex==NULL)return;
	int x=me->x();
	int y=me->y();
	SRect rcClick(x-3,y-3,7,7);
	SSize compSize = m_pComponentIndex->size();
	SPoint pinend;
	int offset;
	int ltrb;
	int maxOffset;
	for(ltrb=0;ltrb<4;ltrb++){
		if(ltrb&1)	maxOffset=compSize.w();
		else		maxOffset=compSize.h();
		for(offset=0;offset<=maxOffset;offset++){
			pinend = pinEndPos(ltrb,offset);
			if(rcClick.intersect(pinend)) break;
		}
		if(offset<=maxOffset) break;
	}
	if(ltrb==4) return;
	if(m_cursorLTRB == ltrb && m_cursorOffset == offset) return;

	QPainter* ppainter = new QPainter(viewport());
	ppainter->translate ( -contentsX(),-contentsY() );
	drawCursor(ppainter,NULL);
	m_cursorLTRB = ltrb;
	m_cursorOffset = offset;
	drawCursor(ppainter,NULL);
	delete ppainter;
	emit cursorMoved();
}

void SComponentView::drawCursor(QPainter*p,const SRect* prcClip)
{
	if(m_cursorLTRB<0) return;
	//qDebug("drawCursor");
	SPoint pinend = pinEndPos(m_cursorLTRB,m_cursorOffset);
	SRect rcCircle(pinend.x()-3,pinend.y()-3,7,7);
	if(prcClip==NULL || rcCircle.intersect(*prcClip)){
		//p->setRasterOp(Qt::NotXorROP);
		QPen pen(QColor("red"));
		p->setPen(pen);
		QBrush brush(Qt::NoBrush);
		p->setBrush(brush);
//Qt4		p->drawEllipse(pinend.x()-3,pinend.y()-3,7,7);
		p->drawEllipse(pinend.x()-3,pinend.y()-3,6,6);
		//p->setRasterOp(Qt::CopyROP);
	}
}


void SComponentView::drawFrame(QPainter*p,const SRect* prcClip)
{
	SSize size=m_pComponentIndex->sizePlace(0);
	int l,t,r,b;
	int w = contentsWidth();
	int h = contentsHeight();
	r=w-40;
	b=h-40;
	l=r-size.w();
	t=b-size.h();

	//ܥǥ
	QPen pen(QColor("LightPink"));
	p->setPen(pen);
	QBrush brush(Qt::NoBrush);
	p->setBrush(brush);
//Qt4	p->drawRect(l,t,size.w()+1,size.h()+1);
	p->drawRect(l,t,size.w(),size.h());

	//ߡԥ
	int s,e,v,i;
	SSize compSize = m_pComponentIndex->size();
	//L
	s=l-PIN_LENGTH;
	e=l;
	v=t;
	if(prcClip->l() <= e && prcClip->r() >= s){
		for(i=0;i<=compSize.h();i++){
			if(v >= prcClip->t() && v <= prcClip->b() ){
				p->drawLine (s,v,e,v);
			}
			v+=10;
		}
	}
	//R
	s=r+PIN_LENGTH;
	e=r;
	v=t;
	if(prcClip->l() <= e && prcClip->r() >= s){
		for(i=0;i<=compSize.h();i++){
			if(v >= prcClip->t() && v <= prcClip->b() ){
				p->drawLine (s,v,e,v);
			}
			v+=10;
		}
	}
	//T
	s=t-PIN_LENGTH;
	e=t;
	v=l;
	if(prcClip->t() <= e && prcClip->b() >= s){
		for(i=0;i<=compSize.w();i++){
			if(v >= prcClip->l() && v <= prcClip->r() ){
				p->drawLine (v,s,v,e);
			}
			v+=10;
		}
	}

	//B
	s=b;
	e=s+PIN_LENGTH;
	v=l;
	if(prcClip->t() <= e && prcClip->b() >= s){
		for(i=0;i<=compSize.w();i++){
			if(v >= prcClip->l() && v <= prcClip->r() ){
				p->drawLine (v,s,v,e);
			}
			v+=10;
		}
	}

}


int SComponentView::contentsWidth()
{
	return viewport()->width();
}
int	SComponentView::contentsHeight()
{
	return viewport()->height();
}

int SComponentView::contentsX()
{
	QScrollBar* scrollBar =  horizontalScrollBar ();
	if(!scrollBar)return 0;
	else return scrollBar->value();
}

int SComponentView::contentsY()
{
	QScrollBar* scrollBar =  verticalScrollBar ();
	if(!scrollBar)return 0;
	else return scrollBar->value();
}

void SComponentView::resizeContents(int width,int height)
{
	viewport()->resize(width,height);
}
//void viewportResizeEvent(QResizeEvent * );

#endif
