
/* math.q: mathematical functions
   $Id: math.q,v 1.8 2006/06/21 08:45:02 agraef Exp $ */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

include cond;

/* IEEE floating point infinities and NaNs. */

public var const inf = 1.0e307 * 1.0e307, nan = inf-inf;

/* Floor and ceil. Round a number to the nearest integer below and above,
   respectively. */

public floor X, ceil X;

floor X:Real	= if N<=X then N else N-1 where N:Int = trunc X;
ceil X:Real	= N where N:Int = -floor (-X);

/* Trigonometric functions: */

public asin X, acos X, tan X;

asin X:Real	= atan2 X (sqrt (1-X*X)) if (X<=1) and then (X>=-1);
			
acos X:Real	= atan2 (sqrt (1-X*X)) X if (X<=1) and then (X>=-1);
			
tan X:Real	= sin X / cos X;

/* Base 2 and 10 logarithms: */

public lg X, log X;

lg X:Real	= ln X / ln 2;
log X:Real	= ln X / ln 10;

/* Hyperbolic functions: */

public sinh X, cosh X, tanh X;

sinh X:Real	= (exp X - exp (-X))/2;
cosh X:Real	= (exp X + exp (-X))/2;
tanh X:Real	= (exp X - exp (-X))/(exp X + exp (-X));

public asinh X, acosh X, atanh X;

asinh X:Real	= ln (X + sqrt (X*X + 1));
acosh X:Real	= ln (X + sqrt (X*X - 1)) if X>=1;
atanh X:Real	= ln ((1 + X) / (1 - X)) / 2 if (X<1) and then (X>-1);
