
/*  Q eQuational Programming System
    Copyright (c) 1991-2002 by Albert Graef
    <ag@muwiinfa.geschichte.uni-mainz.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* interface to the Q machine */

#include <stdio.h>

/* expression data structure */

typedef struct expr {
  int		refc;	/* reference count */
  short         fno;	/* function symbol/opcode */
  short		argc;	/* expected arg count */
  unsigned int	virt:1;	/* virtual flag */
  unsigned int	type:15;/* type (0 if none) */
  unsigned int	red:1;	/* reducible flag */
  unsigned int	raw:1;	/* raw flag */
  unsigned int	mem:1;	/* memoizing flag */
  unsigned int	pipe:1;	/* pipe flag */
#ifdef USE_THREADS
  unsigned int	sticky:1;	/* "sticky" bit */
  int		thrid:11;	/* id of owning thread */
#endif
  union {
    /* INTVALOP: */
    mpz_t		z;	/* big integer value */
    /* FLOATVALOP: */
    double              f;	/* floating point value */
    /* STRVALOP: */
    char	       *s;	/* string value */
    /* FILEVALOP: */
    FILE	       *fp;	/* file value */
#if defined(HAVE_UNICODE) && defined(HAVE_ICONV)
    struct {
      FILE	       *fp;	/* file value */
      iconv_t		ic[2];	/* conversion handles */
    } fargs;
#endif
    /* USRVALOP: */
    void	       *vp;	/* external value */
    /* VECTOP: */
    struct {
      int		n;	/* size */
      struct expr       **xv;	/* elements */
    } vect;
    /* CONSOP, PAIROP, APPOP: */
    struct {
      unsigned long	argv;	/* keep track of special forms */
      struct expr      *x1, *x2;/* arguments */
    } args;
    /* heap management */
    struct expr  *xp;
  } data;
} EXPR;
