/* A basic Q/Qt example. -*- c++ -*- */

%module(directors="1") qt_examp

/**************************************************************************

   You need the Qt libraries to run this example. First make sure that the
   QTDIR environment variable is set properly. Then follow these three steps
   to create and compile the module. (This should work on all Un*x systems,
   adapt the process as needed on Windows.)

   1. Run swig to generate the module. This creates the qt_examp_wrap.cxx
      file.

	swig -c++ -q qt_examp.i

   2. Run Qt's moc on the MyPushButton widget. This creates the
      qt_examp_moc.cxx file.

	$QTDIR/bin/moc qt_examp.h -o qt_examp_moc.cxx

   3. Compile the module with the Q module compiler.

	qcc qt_examp.cxx qt_examp_moc.cxx qt_examp_wrap.cxx -- \
	  -I$QTDIR/include --link -L$QTDIR/lib -lqt -lstdc++

   If all went smoothly, you should now have a qt_examp.q file and the shared
   library that goes with it. Run q qt_examp.q and execute the main function
   of the script.

 **************************************************************************/

%{
#include <qapplication.h>
#include <qpushbutton.h>
#include "qt_examp.h"
%}

/* Make QApplication::exec() have the %preempt feature, so that the
   corresponding wrapper function unlocks the interpreter while executing.
   This allows other Q threads to run while the Qt main loop is executed. We
   don't actually need this in this simple example, but you'll notice the
   difference when your Q script is multithreaded. */

%preempt QApplication::exec;

/* Declare the part of the Qt class hierarchy needed for this example.
   Unfortunately, the Qt header files are not very SWIG-friendly so we rather
   collect the relevant declarations here. */

class QApplication {
public:
  QApplication( int argc, char **argv );
  void setMainWidget( QWidget *widget );
  int exec();
};

/* SWIG will complain about an incomplete base class here. This is
   harmless. */
class QWidget;

class QPushButton : public QWidget {
public:
  QPushButton( char *str, QWidget *w );
  void resize( int x, int y );
  void show();
};

/* This is our "main widget". The actual C++ source is in the qt_examp.h and
   qt_examp.cxx files. Make sure to create a director class here, so that we
   can override the clickedcb callback in the Q script (see below). */

%feature("director") MyPushButton;

class MyPushButton : public QPushButton {
public:
  MyPushButton( char *str, QWidget *w );
  virtual void clickedcb();
};

%stubs %{
/* The callback of the push button. Take an appropriate action here. */

_MyPushButton_clickedcb _ _ = puts "Hi there!\n";

/* Run me to show a little Qt main window with a push button. */

main = _QPushButton_resize BUT 200 60 ||
       _QApplication_setMainWidget APP BUT ||
       _QPushButton_show BUT ||
       _QApplication_exec APP
	 where APP = new_QApplication 0 NULL,
	   BUT = new_MyPushButton () "Hello, world!" NULL;
%}
