#!/bin/sh

# Mangle global internal symbols in the interpreter. I usually run this once
# before release, in order to prevent name clashes between the interpreter and
# external modules on systems which support back-linking.

# Relies on the libglobs.a target in src/Makefile.am. I don't know whether
# this works on anything else but Linux, is there a portable way to do this??

# USAGE: To run, execute this script as mangle.sh SRCDIR in the build
# directory, where SRCDIR denotes the actual top source directory (this
# parameter is only needed if your build directory is different from the
# source directory). Or just run make mangle in the top build directory.

srcdir=$1
srcdir=${srcdir:-.}

if (make -C src clean && rm -f $srcdir/src/mangle.h &&
    touch $srcdir/src/mangle.h && make -C src libglobs.a)
then
  echo '/* mangle.h: created' `date` 'by mangle.sh */' >> $srcdir/src/mangle.h
  echo '' >> $srcdir/src/mangle.h
  nm -B src/libglobs.a | sed -n -e 's/^.*[ 	]\([ABCDGISTW][ABCDGISTW]*\)[ 	][ 	]*\(\)\([_A-Za-z][_A-Za-z0-9]*\)$/\1 \2\3 \3/p' | sed 's/.* //' | sort | uniq | grep -v '^\(yy.*\|main\)$' | sed -e 's/^.*$/#define \0 __qq__\0/g' >> $srcdir/src/mangle.h
  make -C src clean all
fi
echo '***' mangle done '***'
