
/* The gamma function, using the Lanczos approximation.
   Copyright (c) 2007 Eddie Rucker. */

var const pi = 3.1415926535897931;

public gamma Z;

/* Compute exact values for the positive integers, fail for negative or
   zero. */

gamma 1		= 1;
gamma Z:Int	= _FAIL_ if Z <= 0;
		= (Z-1) * gamma (Z-1);

/* Compute the Lanczos approximation for real or complex arguments. */

gamma Z:Num	= pi / (sin (pi*Z) * gamma (1-Z)) if re Z < 0.5;
		= 2.506628274631 * T ^ (Z-0.5) * exp (-T) *
		  (0.99999999999980993 + sum [P!N/(Z+N) : N in [0..7]])
		    where T = Z + 6.5,
		      P = [676.5203681218851, -1259.1392167224028,
			   771.32342877765313, -176.61502916214059,
			   12.507343278686905, -0.13857109526572012,
			   9.9843695780195716e-6, 1.5056327351493116e-7];
