(**************************************************************************)
(*                                                                        *)
(*  Ocamlgraph: a generic graph library for OCaml                         *)
(*  Copyright (C) 2004-2010                                               *)
(*  Sylvain Conchon, Jean-Christophe Filliatre and Julien Signoles        *)
(*                                                                        *)
(*  This software is free software; you can redistribute it and/or        *)
(*  modify it under the terms of the GNU Library General Public           *)
(*  License version 2.1, with the special exception on linking            *)
(*  described in file LICENSE.                                            *)
(*                                                                        *)
(*  This software is distributed in the hope that it will be useful,      *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *)
(*                                                                        *)
(**************************************************************************)

type token =
  | ID of (Dot_ast.id)
  | COLON
  | COMMA
  | EQUAL
  | SEMICOLON
  | EDGEOP
  | STRICT
  | GRAPH
  | DIGRAPH
  | LBRA
  | RBRA
  | LSQ
  | RSQ
  | NODE
  | EDGE
  | SUBGRAPH
  | EOF

val file :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Dot_ast.file
