/*
 * vt100.c
 *
 * written by Kraig Amador and Joshua J. Drake
 */

#include "irc.h"
#include "vars.h"

/* This function returns 1 if the character passed is NOT printable, it
 * returns 0 if the character IS printable.  It doesnt actually do anything
 * with the character, though.
 */
#ifdef __STDC__
int
vt100_decode(u_char chr)
#else
int
vt100_decode(chr)
   u_char chr;
#endif
{
   static enum
   {
      Normal, Escape, SCS, CSI, DCS, DCSData, DCSEscape
   }
   vtstate = Normal;

/*   if (!get_int_var(ANSI_COLOR_VAR))
     return 0;
 */
   
   if (chr == 0x1B)		/* ASCII ESC */
     {
	if (vtstate == DCSData || vtstate == DCSEscape)
	  vtstate = DCSEscape;
	else
	  {
	     vtstate = Escape;
	     return 1;
	  }
     }
   else if (chr == 0x18 || chr == 0x1A)	/* ASCII CAN & SUB */
      vtstate = Normal;

   else if (chr == 0xE || chr == 0xF)	/* ASCII SO & SI */
      ;

   /* C0 codes are dispatched without changing machine state!  Oh, my! */
   else if (chr < 0x20)
      return 0;

   switch (vtstate)
     {
	case Normal:
	   return 0;
	   break;
	case Escape:
	   switch (chr)
	     {
		case '[':
		   vtstate = CSI;
		   break;
		/*
		 * we are only going to support ^[[ stuff
		 *
		case 'P':
		   vtstate = DCS;
		   break;
		case '(':
		case ')':
		   vtstate = SCS;
		   break;
		 */
		default:
		   vtstate = Normal;
	     }
	   return 1;
	   break;
	case SCS:
	   vtstate = Normal;
	   break;
	case CSI:
/*                      if (chr >= 0x40 && chr <= 0x7E) { */
	   if (isalpha(chr))
	      vtstate = Normal;
	   break;
	case DCS:
	   if (chr >= 0x40 && chr <= 0x7E)
	      vtstate = DCSData;
	   break;
	case DCSData:
	   break;
	case DCSEscape:
	   vtstate = Normal;
	   break;
     }
   return 1;
}
