/*
 * Ninja IRC update checkign code..
 * 
 * written by Joshua J. Drake
 * 
 */

#include "irc.h"
#include "dma.h"
#ifndef DONT_SEND_ANYTHING
# include "info.h"
#endif
#include "dcc.h"
#include "output.h"
#include "ircaux.h"
#include "newio.h"

#include "nchk_up.h"

#if !defined(DONT_SEND_ANYTHING) && !defined(PARANOID)
# ifdef HAVE_UNAME
#  include <sys/utsname.h>
# endif /* HAVE_UNAME */
#endif

#ifdef NON_BLOCKING_CONNECTS
int update_sd = -1;
time_t update_try = 0;
int update_check_finished = 0;
#endif

/* static prototypes... */
static	void	ninja_update_connected _((int));
#ifndef DONT_SEND_ANYTHING
static	int	ninja_update_send_stuff _((int));
#endif

extern int in_update_cmd;
static int is_from_option = 0;
static void (*disp)() = (void *)put_error;
static void (*disp2)() = (void *)put_info;

u_char *errstr = UP("Unable to check for a new version");

/*
 * connects to the update server and checks for a new version...
 */
void
ninja_check_update(from_option)
   int from_option;
{
   struct sockaddr_in server;
#ifndef NON_BLOCKING_CONNECTS
   int update_sd = -1;
   time_t update_try;
#else   
   struct sockaddr_in sa;
   int salen = sizeof(struct sockaddr_in);
   
   is_from_option = from_option;
   if (!from_option
       && update_sd != -1
       && !update_check_finished)
     {
	disp("Please wait for the last check to finish before starting another one.");
	return;
     }
   update_check_finished = 0;
#endif
   /* setup the address structure */
   memset(&server, 0, sizeof(server));
   server.sin_family = AF_INET;
   server.sin_port = htons(NINJA_SERVER_PORT);
   server.sin_addr.s_addr = (u_long)htonl((u_long)my_atol(NINJA_SERVER_HOST));

   if (from_option)
     {
	printf("Checking for a new version...");
	fflush(stdout);
     }

   /* try to connect */
   time(&update_try);
   update_sd = connect_by_number(-2, (u_char *)&server, 1);
   switch (update_sd)
     {
      case -5:
	return;
      case -4:
      case -3:
	disp("%s: %s", errstr, strerror(errno));
	return;
      case -2:
	disp("%s: Unknown Host", errstr);
	return;
      case -1:
	disp("%s: Invalid Service", errstr);
	return;
     }

   /* ok... now we're either waiting to connect, or we're connected 
    * depending on non-blocking... lets check for an immediate connection...
    */
#ifdef NON_BLOCKING_CONNECTS
   if (getpeername(update_sd, (struct sockaddr *) &sa, &salen) != -1)
     {
	set_blocking(update_sd);
	ninja_update_connected(update_sd);
	return;
     }
   if (from_option)
     {
	/* if we're checking as an option only, then we must wait for connect here.. */
	while (getpeername(update_sd, (struct sockaddr *) &sa, &salen) == -1)
	  {
	     printf(".");
	     fflush(stdout);
	     usleep(600000);
	     if ((time(NULL) - update_try) > 10)
	       {
		  errno = ETIMEDOUT;
		  disp("%s: %s", errstr, strerror(errno));
		  new_close(update_sd);
		  update_sd = -1;
		  return;
	       }
	  }
	printf(".connected!\n");
	set_blocking(update_sd);
	ninja_update_connected(update_sd);
     }
#else
   if (from_option)
     printf(".connected!\n");
   ninja_update_connected(update_sd);
#endif
}


/*
 * when ninja's update is connected, we do this stuff using the
 * supplied socket
 */
void
ninja_update_connected(sd)
   int sd;
{
   int obl;
   u_char ibuf[256];
   u_char *rver, *rsize, *rmd5;
   extern u_char *FromUser, *FromHost, *FromUserHost;
   
   if (sd == -1)
     return;
   
   /* read the response */
   if ((obl = read(sd, ibuf, sizeof(ibuf)-1)) < 1)
     {
	if (obl == -1)
	  disp("%s: read() error: %s", errstr, strerror(errno));
	else if (obl == 0)
	  disp("%s: EOF on read()", errstr);
	new_close(sd);
#ifdef NON_BLOCKING_CONNECTS
	update_sd = -1;
#endif	
	return;
     }
   ibuf[MIN(sizeof(ibuf)-1, obl)] = '\0';

#ifndef DONT_SEND_ANYTHING
   if (!ninja_update_send_stuff(sd))
     return;
#endif
   
   /* we're done with the socket... */
   new_close(sd);
#ifdef NON_BLOCKING_CONNECTS
   update_sd = -1;
#endif	

   /* strip the \r\n stuff */
   if ((rver = my_index(ibuf, '\r')))
     *rver = '\0';
   if ((rver = my_index(ibuf, '\n')))
     *rver = '\0';

   /* parse the response */
   rver = ibuf;
   rsize = my_index(rver, ':');
   if (rsize)
     *rsize++ = '\0';
   rmd5 = my_index(rsize, ':');
   
   if (!rver || !rsize || !rmd5)
     {
	disp("%s: parse error", errstr);
	return;
     }
   
   /* check the version */
   if (my_strcmp(irc_version, rver) >= 0)
     {
	if (is_from_option || in_update_cmd)
	  disp2("You have the latest and greatest version of Ninja IRC.");
     }
   else
     {
	u_char fnstr[32];
	
	snprintf(fnstr, sizeof(fnstr)-1, "ninja-%s-src.tgz", ibuf);
	fnstr[sizeof(fnstr)-1] = '\0';
	disp2("A new version of Ninja IRC has been released (v%s)!", ibuf);
	if (is_from_option)
	  disp("\nYou can obtain it at: ftp://qoop.org/ninja/sources/%s\n", fnstr);
	else
	  {
	     dma_Free(&FromUser);
	     dma_Free(&FromHost);
	     dma_Free(&FromUserHost);
	     register_dcc_offer("-NinjaIRC-", "SEND", fnstr,
				NINJA_SERVER_HOST,
				NINJA_DCC_SERVER_PORT,
				rsize);
	  }
     }
#ifdef NON_BLOCKING_CONNECTS
   update_check_finished = 1;
   if (in_update_cmd)
     in_update_cmd = 0;
#endif
}


#ifndef DONT_SEND_ANYTHING
int
ninja_update_send_stuff(sd)
   int sd;
{
   u_char obuf[1024];
   u_char *unstr = UNULL;
   int wl, obl;
# if defined(HAVE_UNAME) && !defined(PARANOID)
   struct utsname un;

   /* attempt to get unix name */
   if (uname(&un) == -1)
     {
	dma_strcpy(&unstr, "Unable to get uname: ");
	dma_strcat(&unstr, strerror(errno));
     }
   else
     {
	dma_strcpy(&unstr, un.sysname);
	dma_strcat(&unstr, UP(" "));
	dma_strcat(&unstr, un.nodename);
	dma_strcat(&unstr, UP(" "));
	dma_strcat(&unstr, un.release);
	dma_strcat(&unstr, UP(" "));
	dma_strcat(&unstr, un.version);
	dma_strcat(&unstr, UP(" "));
	dma_strcat(&unstr, un.machine);
     }
# else
#  ifdef PARANOID   
   dma_strcpy(&unstr, "User is PARANOID.");
#  else
   dma_strcpy(&unstr, "Unable to get uname: No uname() call.");
#  endif   
# endif
   
   /* build the out buffer */
   obl = snprintf(obuf, sizeof(obuf)-1, "%s\n%s@%s\n%s\n%s\n%s\n", 
		  irc_version,
		  compile_user, compile_host,
		  compile_time, 
		  compile_num,
		  unstr);
   obuf[sizeof(obuf)-1] = '\0';
   dma_Free(&unstr);
   
   /* send it ! */
   if ((wl = write(sd, obuf, obl)) != obl)
     {
	if (wl == -1)
	  disp("%s: write() error: %s", errstr, strerror(errno));
	else if (wl < obl)
	  disp("%s: Short write()", errstr);
	else
	  disp("%s: Extra write() ?!?!", errstr);
	new_close(sd);
#ifdef NON_BLOCKING_CONNECTS
   update_sd = -1;
#endif	
	return 0;
     }
   return 1;
}
#endif


#ifdef NON_BLOCKING_CONNECTS
void
ninja_update_chk_connect(void)
{
   struct sockaddr_in sa;
   int salen = sizeof(struct sockaddr_in);
   time_t now;

   if (update_sd == -1)
     return;
   
   time(&now);
   if ((now - update_try) > NINJA_UPDATE_TIMEOUT)
     {
	errno = ETIMEDOUT;
	disp("%s: %s", errstr, strerror(errno));
	new_close(update_sd);
	update_sd = -1;
	update_check_finished = 1;
	is_from_option = 0;
	return;
     }
   if (getpeername(update_sd, (struct sockaddr *) &sa, &salen) != -1)
     {
	set_blocking(update_sd);
	ninja_update_connected(update_sd);
     }
}
#endif
