/*
 * socks.h: header file for socks.c
 * 
 * this stuff is for internal socks4/socks5 support.
 * That's right, no libsocks needed!
 * 
 * written by Joshua J. Drake <jduck@EFNet>
 */

#ifndef __socks_h
#define __socks_h

/* defines for socks 5 stuff */
#define SOCKS_PORT	1080
#define SOCKS4_VERSION	4
#define SOCKS5_VERSION	5

/* auth types */
#define AUTH_NONE       0x00
#define AUTH_GSSAPI     0x01
#define AUTH_PASSWD     0x02
#define AUTH_CHAP       0x03

/* auth errors */
#define AUTH_OK        0
#define AUTH_FAIL      -1

/* commands */
#define SOCKS_CONNECT   1
#define SOCKS_BIND      2
#define SOCKS_UDP       3
#define SOCKS_PING      0x80
#define SOCKS_TRACER    0x81
#define SOCKS_ANY       0xff

/* errors */
#define SOCKS5_NOERR            0x00
#define SOCKS5_RESULT           0x00
#define SOCKS5_FAIL             0x01
#define SOCKS5_AUTHORIZE        0x02
#define SOCKS5_NETUNREACH       0x03
#define SOCKS5_HOSTUNREACH      0x04
#define SOCKS5_CONNREF          0x05
#define SOCKS5_TTLEXP           0x06
#define SOCKS5_BADCMND          0x07
#define SOCKS5_BADADDR          0x08

/* flags */
#define SOCKS5_FLAG_NONAME      0x01
#define SOCKS5_FLAG_VERBOSE     0x02
#define SOCKS5_IPV4ADDR         0x01
#define SOCKS5_HOSTNAME         0x03
#define SOCKS5_IPV6ADDR         0x04

/* socks v5 passwd struct */
struct socks5_pw {
   u_char	ver;
   u_char	ulen;
   u_char	*user;
   u_char	plen;
   u_char	*pass;
};

/* function prototypes */
	u_char	*socks4_error _((int));
	u_char	*socks5_error _((int));
	int	socks4_connect _((int, struct sockaddr_in));


	int	socks5_connect _((int, struct sockaddr_in));
/* these are called by socks5_connect, but it blocks while using them */
	int	socks5_send_auth_req _((int));
	int	socks5_recv_auth_rep _((int));
	int	socks5_send_userpass_req _((int));
	int	socks5_recv_userpass_rep _((int));
	int	socks5_send_connect_req _((int, struct sockaddr_in));
	int	socks5_recv_connect_rep _((int));

#endif
