/*
 * enemies.h: header file for enemies.c
 * 
 * this file contains stuff that supports Ninja IRC's
 * enemy list.
 * 
 * written by Kraig Amador with tweak from Joshua J. Drake
 */
#ifndef __enemies_h
#define __enemies_h

typedef struct	ecList_stru
{
	struct	ecList_stru	*next;
	u_char	*channel;
	u_char	level;
	time_t	date;
	u_char	*reason;
}	EChan;

typedef struct	enemy_list_stru
{
	struct	enemy_list_stru	*next;
	u_char	*host;
	EChan *channels;
}	Enemy;

/* enemy list head */
extern	Enemy	*enemy_list;

/* function prototypes */
	Enemy	*get_enemy _((u_char *));
	EChan	*get_enemy_chan _((Enemy *, u_char *, int));
	/* /commands */
	void	add_enemy _((u_char *, u_char *, u_char *));
	void	add_enemy_chan _((u_char *, u_char *, u_char *));
	void	show_enemies _((u_char *, u_char *, u_char *));

	int	load_enemies _((int));
	int	save_enemies _((int));

/* routine prototpes */

#endif
