/*  NETMAJ-XUI -- X User Interface --  Copyright Notice
 *
 *      Copyright (c) 1995,1996 Todo Software All rights reserved.
 *
 *   You can redistribute it and/or modify this software under the terms
 *  of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *   This software is provided 'as-is', without any express or implied
 *  warranty.  In no event will the author be held liable for any damages
 *  arising from the use of this software.
 *  See the gpl.text for more details.
 *
 *   If you would like to do something with NETMAJ that this copyright
 *  prohibits (such as distributing it with a commercial product,
 *  using portions of the source in some other program, etc.), please
 *  contact the author (preferably via email).  Arrangements can
 *  probably be worked out.
 *
 *   Todo Software : NBC02365@niftyserve.or.jp
 */
/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * pixyaku.c -- 
 * 
 * $Id: pixyaku.c,v 1.3 1996/07/31 22:50:19 suz Exp $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:14:51 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Fri Aug 18 05:20:41 1995
 *   yaku pixmaps
 *  Copyright (C) 1995,1996 Todo Software All rights reserved
 */


#include "xnet.h"
#include "pixread.h"

#include "bitmap/yaku/yaku.xpm"


#ifndef TEXTYAKU
static char **yaku_data[] =
{
  fbitmap (y0),
  fbitmap (y1),
  fbitmap (y2),
  fbitmap (y3),
  fbitmap (y4),
  fbitmap (y5),
  fbitmap (y6),
  fbitmap (y7),
  fbitmap (y8),
  fbitmap (y9),
  fbitmap (y10),
  fbitmap (y11),
  fbitmap (y12),
  fbitmap (y13),
  fbitmap (y14),
  fbitmap (y15),
  fbitmap (y16),
  fbitmap (y17),
  fbitmap (y18),
  fbitmap (y19),
  fbitmap (y20),
  fbitmap (y21),
  fbitmap (y22),
  fbitmap (y23),
  fbitmap (y24),
  fbitmap (y25),
  fbitmap (y26),
  fbitmap (y27),
  fbitmap (y28),
  fbitmap (y29),
  fbitmap (y30),
  fbitmap (y31),
  fbitmap (y32),
  fbitmap (y33),
  fbitmap (y34),
  fbitmap (y35),
  fbitmap (y36),
  fbitmap (y37),
  fbitmap (y38),
  fbitmap (y39),
  fbitmap (y40),
  fbitmap (y41),
  fbitmap (y42),
  fbitmap (y43),
  fbitmap (y44),
  fbitmap (y45),
  fbitmap (y46),
  fbitmap (y47),
  fbitmap (y48),
  fbitmap (y49),
  fbitmap (y50),
  fbitmap (y51),
  fbitmap (y52),
  fbitmap (y53),
  fbitmap (y54),
  fbitmap (y55),
  fbitmap (y56),
  0,
};

gpixmap2_t
yaku2pix (n)
     int n;
{
  if (!yaku_data[n])
    return 0;
  if (!pm_yaku[n].pm)
    {
      read_pix_idx (yaku_data[n], pm_yaku[n]);
    }
  return &pm_yaku[n];
}
#endif

#include "bitmap/misc/rryukyok.xpm"
#include "bitmap/misc/rtumo.xpm"
#include "bitmap/misc/rron.xpm"
#include "bitmap/misc/rchonbo.xpm"
#include "bitmap/misc/pointh.xpm"
#include "bitmap/misc/gameendh.xpm"
#include "bitmap/misc/fusfx.xpm"
#include "bitmap/misc/fansfx.xpm"
#include "bitmap/misc/yakuura.xpm"
#include "bitmap/misc/yakuaka.xpm"
#include "bitmap/misc/yakudora.xpm"

void
read_result_name ()
{
  read_pix_idx (rryukyoku_xpm, pm_result_name[1]);
  pm_result_name[2] = pm_result_name[1];
  read_pix_idx (rchonbo_xpm, pm_result_name[3]);
  pm_result_name[4] = pm_result_name[3];
  read_pix_idx (rtumo_xpm, pm_result_name[5]);
  read_pix_idx (rron_xpm, pm_result_name[6]);

  read_pix (pointh, pm_point_header);
  read_pix (fusfx, pm_point_fu_sfx);
  read_pix (fansfx, pm_point_fan_sfx);
  read_pix (gameendh, pm_gameend_header);
  read_pix (yakudora, pm_yaku_dora_str);
  read_pix (yakuura, pm_yaku_uradora_str);
  read_pix (yakuaka, pm_yaku_akadora_str);
}
