/*  NETMAJ-XUI -- X User Interface --  Copyright Notice
 *
 *      Copyright (c) 1995,1996 Todo Software All rights reserved.
 *
 *   You can redistribute it and/or modify this software under the terms
 *  of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *   This software is provided 'as-is', without any express or implied
 *  warranty.  In no event will the author be held liable for any damages
 *  arising from the use of this software.
 *  See the gpl.text for more details.
 *
 *   If you would like to do something with NETMAJ that this copyright
 *  prohibits (such as distributing it with a commercial product,
 *  using portions of the source in some other program, etc.), please
 *  contact the author (preferably via email).  Arrangements can
 *  probably be worked out.
 *
 *   Todo Software : NBC02365@niftyserve.or.jp
 */
/*  -*- Mode: C -*- 
 * This file is part of xnetmaj
 * 
 * decl.h -- 
 * 
 * $Id: decl.h,v 1.2 1996/07/31 22:49:39 suz Exp $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Tue Apr 11 11:14:40 1995
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jan 25 22:52:19 1996
 * 
 *  Copyright (C) 1995,1996 Todo Software All rights reserved
 */
#include "xnet.h"
#include "xnetmaj.h"
#include "pixread.h"
#include "mydir.h"

#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* about.c */
void about_init P_((void));
void make_about P_((void));
void about_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* advice.c */
void read_advice_pixmaps P_((void));
integer_t tenpai_p P_((global_t *gp, integer_t who));
void advice_button_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void quick_log_button_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void advice_clear P_((void));
void advice_clear_flush P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* advice2.c */
void read_tiny_pixmaps P_((void));
void hand_pai_advice_info_clear P_((void));
void hand_pai_advice_info_display P_((global_t *gp));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* attr.c */
void attr_init P_((void));
gpixmap2_t attr2pix P_((attr_t n, integer_t kind));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* auto.c */
void one_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void auto_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
unsigned int randval P_((void));
void auto_init P_((void));
void autoplay_config P_((void));
void autoplay_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void auto_after_reach_config P_((void));
void auto_after_reach_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* bdcolor.c */
void colorcombo_init P_((void));
integer_t get_basiccolorpixel P_((void));
void set_basiccolorpixel P_((char *name));
widget_t bdcolor_init P_((void));
void bdcolor_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* bg.c */
void bg_init P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* board.c */
void board_button3press_callback P_((void));
void quit_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void check_callback P_((global_t *gp));
void get_choice P_((global_t *gp));
void board_sync P_((void));
void board_flush_sfx P_((void));
void board_flush P_((void));
void board_button_flush P_((void));
void board_display P_((void));
void make_board P_((void));
void board_redraw P_((integer_t sfx));
void board_reset P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* class.c */
widget_t create_class_frame P_((widget_t parent));
void info_class P_((char *name));
void class_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* config.c */
void config_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* dummy.c */

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* flags.c */

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* getline.c */
long integerF P_((integer_t i));
double floatF P_((integer_t i));
char *stringF P_((integer_t i));
integer_t numberofF P_((void));
integer_t div_into_fields P_((char *s, integer_t buflen));
char **pointerF P_((void));
integer_t getline P_((FILE *fp));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* handler.c */
void save_handler P_((void *object, int (*savedaction)()));
boolean invoke_handlers P_((void));
void save_iohandler P_((int fd, char *mode, int (*handler)()));
void save_X_iohandler P_((int fd));
void free_iohandler P_((int fd));
void invoke_iohandlers P_((fd_set *rfd, int count));
int get_iohandler_fd_set_width P_((char *mode));
fd_set *get_iohandler_fd_set P_((char *mode));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* help.c */
void help_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* hora.c */
void hora_init P_((widget_t parent, integer_t width));
void hora_reset P_((void));
void hora_set P_((global_t *gp, integer_t who));
void draw_hora P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* init.c */
void keywait_callback P_((void));
void wait_key P_((void));
void openning P_((void));
void setup P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* itime.c */
void set_timer_handler P_((int (*func)(), int interval));
void clear_timer_handler P_((void));
void stop_timer P_((void));
void resume_timer P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* lang.c */
void lang_set P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* msg.c */
void message_unmap P_((void));
void message_init P_((widget_t r[4], widget_t msg[4]));
void msg_tick P_((void));
void msg_bg_init P_((void));
void msg_bg_done P_((void));
int ui_message_fail_connect P_((void));
int ui_message_connecting P_((void));
int ui_message_connect P_((void));
int ui_message_disconnect P_((void));
int ui_message_reach P_((int i));
void wait4key P_((void));
void stop_config P_((void));
void stop_button_callback P_((void));
int ui_message_tumo P_((int i));
int ui_message_ron P_((int i));
int ui_message_player P_((global_t *gp));
int ui_message_play P_((global_t *gp));
void speed_config P_((void));
void speed_callback P_((void));
int comment P_((int from, int i, char *body));
int popup P_((char *msg, int i));
void send_play_message_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void sound_config P_((void));
void sound_button_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pfdir.c */
DIR *xopendir P_((char *name));
integer_t read_dentry P_((char *name));
void close_dentry P_((void));
integer_t n_pf_file P_((void));
integer_t get_pf_file P_((char **array));
void free_pf_file P_((unsigned long n, char **array));
void check_pf_file P_((char *name));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pfinfo.c */
void read_player_info_last P_((char *name, integer_t count));
void tolowers P_((char *s));
int read_player_info P_((char *name));
int read_player_first_info P_((void));
int read_player_next_info P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pixattr.c */
void read_attr_pixmaps P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pixbdig.c */
void pmcontainer_set_bdigit P_((widget_t w, integer_t val));
void read_bdigit_pixmap P_((void));
void pmcontainer_set_adigit P_((widget_t w, integer_t val, integer_t flag));
void read_adigit_pixmap P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pixdec.c */
void read_decorate_pixmaps P_((void));
void read_openning_pixmaps P_((void));
void actionbutton_setup P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pixmisc.c */
void read_misc_pixmaps P_((void));
void read_pinfo_pixmap P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pixpai.c */
gpixmap2_t pai2pix P_((integer_t n, integer_t pos, integer_t reach, integer_t opened));
void pai2pix_init P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pixread.c */
void read_pixmaps P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* pixyaku.c */
gpixmap2_t yaku2pix P_((int n));
void read_result_name P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* playinfo.c */
void pinfo_init P_((void));
void pinfo_clear P_((void));
void pinfo_dir_clear P_((void));
void pinfo_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* rank.c */
void rank_init P_((void));
void rank_clear P_((void));
struct playerinfo *playerinfo_sort_append P_((struct playerinfo *list, struct playerinfo *p, integer_t (*compare)()));
void rank_display P_((void));
void rank_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* rc.c */
void save_rcfile P_((FILE *fp));
void load_rcfile P_((char *buf));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* res.c */
int ui_res P_((global_t *gp, int *howp));
int _ui_res P_((global_t *gp, int *howp));
int ui_choice P_((global_t *gp));
int _ui_choice P_((global_t *gp));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* talkcmd.c */
void comment_divide P_((char *src, char *dest1, char *dest2));
void comment_exec_command P_((char *s));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* testpai.c */
void testpai_init P_((void));
void testpai_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* title.c */
widget_t title_create P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* version.c */

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* x11intin.c */
void save_rcfile P_((FILE *fp));
void load_rcfile P_((char *buf));
void save_xrcfile P_((void));
void load_xrcfile P_((void));

#undef P_
#if __STDC__ || ANSIC
#define P_(s) s
#else
#define P_(s) ()
#endif

/* xui.c */
integer_t mytblpos P_((integer_t i));
integer_t pos2who P_((integer_t i));
void ui_init P_((global_t *gp, int kind, char *type));
void ui_term P_((void));
int _print_digit P_((widget_t w, integer_t val));
void print_pmdigit P_((widget_t w, integer_t val));
void _print_str P_((widget_t w, char *s));
void draw_title P_((global_t *gp));
int ui_key P_((void));
void ui_draw P_((global_t *gp, int redraw));
void ui_expose P_((global_t *gp));
int ui_menu P_((global_t *gp, int c));
integer_t ui_event_wait P_((global_t *gp, int time_out));
void board_button_map P_((integer_t flag));
void board_button_display P_((integer_t flag));
void board_button_unmap P_((void));
integer_t choice P_((global_t *gp, int n_draw, int argc, gpixmap2_t argv[], int st, int flag));
void mark P_((widget_t canvas, widget_t));
void restart_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void game_redraw P_((void));
void flush_callback P_((widget_t w, integer_t val, struct callbackarg *arg));
void invisible_config P_((void));
void visible_callback P_((widget_t w, integer_t val, struct callbackarg *arg));

#undef P_
#if __STDC__ || ANSI
#define P_(s) s
#else
#define P_(s) ()
#endif

/* yaku.c */
widget_t create_basic_info_frame P_((char *type, widget_t parent, widget_t pmframes[6], integer_t centerwidth, integer_t frame3_p, integer_t button_p));
void point_init P_((void));
int ui_result P_((global_t *gp));
void gameend_init P_((void));
void gameend_clear P_((void));
int ui_message_gend P_((global_t *gp));
void make_point P_((void));

#undef P_
