/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Composite;
import base.drawable.InputAPI;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.clog2.MixedDataInputStream;
import logformat.clog2.RecBare;
import logformat.clog2.RecCargo;
import logformat.clog2.RecColl;
import logformat.clog2.RecComm;
import logformat.clog2.RecDefConst;
import logformat.clog2.RecDefEvent;
import logformat.clog2.RecDefMsg;
import logformat.clog2.RecDefState;
import logformat.clog2.RecHeader;
import logformat.clog2.RecMsg;
import logformat.clog2.RecSrc;
import logformat.clog2.RecTshift;
import logformat.clog2TOdrawable.ColorNameMap;
import logformat.clog2TOdrawable.CommProcThdIDMap;
import logformat.clog2TOdrawable.ObjDef;
import logformat.clog2TOdrawable.ObjMethod;
import logformat.clog2TOdrawable.Topo_Arrow;
import logformat.clog2TOdrawable.Topo_Event;
import logformat.clog2TOdrawable.Topo_State;
import logformat.clog2TOdrawable.TwoEventsMatching;

public class InputLog
extends logformat.clog2.InputLog
implements InputAPI {
    private int next_avail_kindID;
    private TopologyIterator itr_topo = null;
    private ContentIterator itr_objdef_dobj = null;
    private YCoordMapIterator itr_ycoordmap = null;
    private boolean isFirstPeekForCategory;

    public InputLog(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.itr_topo = new TopologyIterator(-1);
        this.isFirstPeekForCategory = true;
    }

    public Kind peekNextKind() {
        switch (this.next_avail_kindID) {
            case -1: {
                if (this.itr_topo.hasNext()) {
                    return Kind.TOPOLOGY;
                }
                this.itr_objdef_dobj = new ContentIterator(1);
                return Kind.CATEGORY;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.itr_objdef_dobj.hasNext()) {
                    switch (this.next_avail_kindID) {
                        case 3: {
                            return Kind.CATEGORY;
                        }
                        case 1: {
                            return Kind.PRIMITIVE;
                        }
                        case 2: {
                            return Kind.COMPOSITE;
                        }
                    }
                }
                this.itr_ycoordmap = new YCoordMapIterator(4);
            }
            case 4: {
                if (this.itr_ycoordmap.hasNext()) {
                    return Kind.YCOORDMAP;
                }
            }
            case 0: {
                return Kind.EOF;
            }
        }
        System.err.println("InputLog.peekNextKind(): Error!\n\tUnknown Kind ID: " + this.next_avail_kindID);
        return null;
    }

    public Topology getNextTopology() {
        return (Topology)this.itr_topo.next();
    }

    public Category getNextCategory() {
        if (this.isFirstPeekForCategory) {
            this.isFirstPeekForCategory = false;
            return this.itr_objdef_dobj.getArrowCategory();
        }
        return (Category)this.itr_objdef_dobj.next();
    }

    public YCoordMap getNextYCoordMap() {
        return (YCoordMap)this.itr_ycoordmap.next();
    }

    public Primitive getNextPrimitive() {
        return (Primitive)this.itr_objdef_dobj.next();
    }

    public Composite getNextComposite() {
        return (Composite)this.itr_objdef_dobj.next();
    }

    public void close() {
        super.close();
    }

    public long getNumberOfUnMatchedEvents() {
        return this.itr_objdef_dobj.getNumberOfUnMatchedEvents();
    }

    public long getTotalBytesRead() {
        return this.itr_objdef_dobj.getTotalBytesRead();
    }

    private class ContentIterator
    implements Iterator {
        private MixedDataInputStream blk_ins;
        private long total_bytesize;
        private CommProcThdIDMap cptIDmap;
        private Map evtdefs;
        private List topos;
        private ObjDef statedef;
        private ObjDef arrowdef;
        private ObjDef eventdef;
        private ObjDef dobjdef;
        private Primitive drawobj;
        private RecHeader header;
        private RecDefState staterec;
        private RecDefEvent eventrec;
        private RecDefConst constrec;
        private RecBare bare;
        private RecCargo cargo;
        private RecMsg msg;
        private RecColl coll;
        private RecComm comm;
        private RecSrc src;
        private RecTshift tshift;
        private Topo_Event eventform;
        private Topo_Arrow arrowform;
        private Topo_State stateform;
        private Object[] arglist;

        public ContentIterator(int n) {
            int n2 = InputLog.super.getPreamble().getMaxThreadCount();
            this.cptIDmap = new CommProcThdIDMap(n2);
            this.cptIDmap.initialize();
            InputLog.this.next_avail_kindID = n;
            this.evtdefs = new HashMap();
            this.topos = new ArrayList();
            ColorNameMap.initMapFromRGBtxt("jumpshot.colors");
            ObjDef.setFirstNextCategoryIndex(0);
            this.arrowform = new Topo_Arrow();
            int n3 = ObjDef.getNextCategoryIndex();
            this.arrowdef = new ObjDef(n3, new RecDefMsg(), (Topology)this.arrowform, 3);
            this.arrowdef.setColor(new ColorAlpha(this.arrowdef.getColor(), 255));
            this.arrowform.setCategory(this.arrowdef);
            this.evtdefs.put(this.arrowdef.start_evt, this.arrowform.getStartEventObjMethod());
            this.evtdefs.put(this.arrowdef.final_evt, this.arrowform.getFinalEventObjMethod());
            List list = InputLog.super.getKnownUndefinedInitedStateDefs();
            list.addAll(InputLog.super.getUserUndefinedInitedStateDefs());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.staterec = (RecDefState)iterator.next();
                this.stateform = new Topo_State();
                n3 = ObjDef.getNextCategoryIndex();
                this.statedef = new ObjDef(n3, this.staterec, (Topology)this.stateform, 1);
                this.stateform.setCategory(this.statedef);
                this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
                this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
            }
            list = InputLog.super.getKnownUndefinedInitedEventDefs();
            list.addAll(InputLog.super.getUserUndefinedInitedEventDefs());
            iterator = list.iterator();
            while (iterator.hasNext()) {
                this.eventrec = (RecDefEvent)iterator.next();
                this.eventform = new Topo_Event();
                n3 = ObjDef.getNextCategoryIndex();
                this.eventdef = new ObjDef(n3, this.eventrec, (Topology)this.eventform, 1);
                this.eventform.setCategory(this.eventdef);
                this.evtdefs.put(this.eventdef.start_evt, this.eventform.getEventObjMethod());
            }
            this.header = new RecHeader();
            this.staterec = new RecDefState();
            this.eventrec = new RecDefEvent();
            this.constrec = new RecDefConst();
            this.bare = new RecBare();
            this.cargo = new RecCargo();
            this.msg = new RecMsg();
            this.coll = new RecColl();
            this.comm = new RecComm();
            this.src = new RecSrc();
            this.tshift = new RecTshift();
            this.arglist = new Object[2];
            this.total_bytesize = 0L;
            this.blk_ins = InputLog.super.getBlockStream();
        }

        public boolean hasNext() {
            while (this.blk_ins != null) {
                int n = -1;
                block27: while (n != 1 && n != 0) {
                    int n2 = this.header.readFromDataStream(this.blk_ins);
                    this.total_bytesize += (long)n2;
                    n = this.header.getRecType();
                    switch (n) {
                        case 2: {
                            n2 = this.staterec.readFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.staterec.startetype);
                            ObjMethod objMethod2 = (ObjMethod)this.evtdefs.get(this.staterec.finaletype);
                            if (objMethod == null || objMethod2 == null) {
                                this.stateform = new Topo_State();
                                int n3 = ObjDef.getNextCategoryIndex();
                                this.statedef = new ObjDef(n3, this.staterec, (Topology)this.stateform, 1);
                                this.stateform.setCategory(this.statedef);
                                this.evtdefs.put(this.statedef.start_evt, this.stateform.getStartEventObjMethod());
                                this.evtdefs.put(this.statedef.final_evt, this.stateform.getFinalEventObjMethod());
                            } else if (objMethod.obj == objMethod2.obj) {
                                this.stateform = (Topo_State)objMethod.obj;
                                this.statedef = (ObjDef)this.stateform.getCategory();
                                this.statedef.setName(this.staterec.name);
                                this.statedef.setColor(ColorNameMap.getColorAlpha(this.staterec.color));
                                this.statedef.setInfoKeys(this.staterec.format);
                            } else {
                                System.err.println("**** Error! " + objMethod.obj + "!=" + objMethod2.obj);
                            }
                            this.dobjdef = this.statedef;
                            InputLog.this.next_avail_kindID = 3;
                            return true;
                        }
                        case 3: {
                            n2 = this.eventrec.readFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.eventrec.etype);
                            if (objMethod == null) {
                                this.eventform = new Topo_Event();
                                int n4 = ObjDef.getNextCategoryIndex();
                                this.eventdef = new ObjDef(n4, this.eventrec, (Topology)this.eventform, 1);
                                this.eventform.setCategory(this.eventdef);
                                this.evtdefs.put(this.eventdef.start_evt, this.eventform.getEventObjMethod());
                            } else {
                                this.eventform = (Topo_Event)objMethod.obj;
                                this.eventdef = (ObjDef)this.eventform.getCategory();
                                this.eventdef.setName(this.eventrec.name);
                                this.eventdef.setColor(ColorNameMap.getColorAlpha(this.eventrec.color));
                                this.eventdef.setInfoKeys(this.eventrec.format);
                            }
                            this.dobjdef = this.eventdef;
                            InputLog.this.next_avail_kindID = 3;
                            return true;
                        }
                        case 4: {
                            n2 = this.constrec.skipBytesFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            continue block27;
                        }
                        case 5: {
                            n2 = this.bare.readFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            int n5 = this.bare.etype;
                            if (n5 == -1) continue block27;
                            ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.bare.etype);
                            this.arglist[0] = this.header;
                            this.arglist[1] = null;
                            this.drawobj = null;
                            try {
                                this.drawobj = (Primitive)objMethod.method.invoke(objMethod.obj, this.arglist);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                illegalAccessException.printStackTrace();
                                System.err.println("Offending RecBare = " + this.bare);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                invocationTargetException.printStackTrace();
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                                System.err.println("Offending RecHeader = " + this.header);
                                System.err.println("Offending RecBare = " + this.bare);
                                System.exit(1);
                            }
                            if (this.drawobj == null) continue block27;
                            this.cptIDmap.setCommProcThdIDUsed(this.drawobj);
                            InputLog.this.next_avail_kindID = 1;
                            return true;
                        }
                        case 6: {
                            n2 = this.cargo.readFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            int n6 = this.cargo.etype;
                            if (n6 == -1) continue block27;
                            ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.cargo.etype);
                            this.arglist[0] = this.header;
                            this.arglist[1] = this.cargo;
                            this.drawobj = null;
                            try {
                                this.drawobj = (Primitive)objMethod.method.invoke(objMethod.obj, this.arglist);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                illegalAccessException.printStackTrace();
                                System.err.println("Offending RecCargo = " + this.cargo);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                invocationTargetException.printStackTrace();
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                                System.err.println("Offending RecHeader = " + this.header);
                                System.err.println("Offending RecCargo = " + this.cargo);
                                System.exit(1);
                            }
                            if (this.drawobj == null) continue block27;
                            this.cptIDmap.setCommProcThdIDUsed(this.drawobj);
                            InputLog.this.next_avail_kindID = 1;
                            return true;
                        }
                        case 7: {
                            n2 = this.msg.readFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            int n7 = this.msg.etype;
                            if (n7 == -1) continue block27;
                            ObjMethod objMethod = (ObjMethod)this.evtdefs.get(this.msg.etype);
                            this.arglist[0] = this.header;
                            this.arglist[1] = this.msg;
                            this.drawobj = null;
                            try {
                                this.drawobj = (Primitive)objMethod.method.invoke(objMethod.obj, this.arglist);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                illegalAccessException.printStackTrace();
                                System.err.println("Offending RecMsg = " + this.msg);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                invocationTargetException.printStackTrace();
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                                System.err.println("Offending RecHeader = " + this.header);
                                System.err.println("Offending RecMsg = " + this.msg);
                                System.exit(1);
                            }
                            if (this.drawobj == null) continue block27;
                            this.cptIDmap.setCommProcThdIDUsed(this.drawobj);
                            InputLog.this.next_avail_kindID = 1;
                            return true;
                        }
                        case 8: {
                            n2 = this.coll.skipBytesFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            continue block27;
                        }
                        case 9: {
                            n2 = this.comm.readFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            this.cptIDmap.addComm(this.comm);
                            continue block27;
                        }
                        case 10: {
                            n2 = this.src.skipBytesFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            continue block27;
                        }
                        case 11: {
                            n2 = this.tshift.skipBytesFromDataStream(this.blk_ins);
                            this.total_bytesize += (long)n2;
                            continue block27;
                        }
                        case 1: {
                            this.blk_ins = InputLog.super.getBlockStream();
                            continue block27;
                        }
                        case 0: {
                            this.blk_ins = null;
                            continue block27;
                        }
                    }
                    System.err.println("Unknown Record type = " + n);
                }
            }
            return false;
        }

        public Object next() {
            switch (InputLog.this.next_avail_kindID) {
                case 3: {
                    this.topos.add(this.dobjdef.getTopology());
                    return this.dobjdef;
                }
                case 1: {
                    return this.drawobj;
                }
            }
            return null;
        }

        public void remove() {
        }

        public Category getArrowCategory() {
            this.topos.add(this.arrowdef.getTopology());
            return this.arrowdef;
        }

        public List getYCoordMapList() {
            this.cptIDmap.finish();
            return this.cptIDmap.createYCoordMapList();
        }

        public long getTotalBytesRead() {
            return this.total_bytesize;
        }

        public long getNumberOfUnMatchedEvents() {
            int n = 0;
            Iterator iterator = this.topos.iterator();
            while (iterator.hasNext()) {
                Topology topology = (Topology)iterator.next();
                if (!(topology instanceof TwoEventsMatching)) continue;
                n += ((TwoEventsMatching)((Object)topology)).getPartialObjects().size();
            }
            return n;
        }
    }

    private class YCoordMapIterator
    implements Iterator {
        private Iterator ycoordmap_itr;
        private YCoordMap next_ycoordmap;

        public YCoordMapIterator(int n) {
            InputLog.this.next_avail_kindID = n;
            List list = InputLog.this.itr_objdef_dobj.getYCoordMapList();
            this.ycoordmap_itr = list.iterator();
            this.next_ycoordmap = this.ycoordmap_itr.hasNext() ? (YCoordMap)this.ycoordmap_itr.next() : null;
        }

        public boolean hasNext() {
            return this.next_ycoordmap != null;
        }

        public Object next() {
            YCoordMap yCoordMap = this.next_ycoordmap;
            this.next_ycoordmap = this.ycoordmap_itr.hasNext() ? (YCoordMap)this.ycoordmap_itr.next() : null;
            return yCoordMap;
        }

        public void remove() {
        }
    }

    private class TopologyIterator
    implements Iterator {
        private int num_topology_returned;

        public TopologyIterator(int n) {
            InputLog.this.next_avail_kindID = n;
            this.num_topology_returned = 0;
        }

        public boolean hasNext() {
            return this.num_topology_returned < 3;
        }

        public Object next() {
            switch (this.num_topology_returned) {
                case 0: {
                    this.num_topology_returned = 1;
                    return Topology.EVENT;
                }
                case 1: {
                    this.num_topology_returned = 2;
                    return Topology.STATE;
                }
                case 2: {
                    this.num_topology_returned = 3;
                    return Topology.ARROW;
                }
            }
            System.err.println("All Topologies have been returned.");
            return null;
        }

        public void remove() {
        }
    }
}

