/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.Coord;
import base.drawable.Primitive;
import base.drawable.YCoordMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import logformat.clog2.RecComm;
import logformat.clog2TOdrawable.CommProcThdID;

public class CommProcThdIDMap
extends TreeMap {
    private static final long serialVersionUID = 300L;
    private int max_thread_count;

    public CommProcThdIDMap(int n) {
        super(Coord.LINEID_ORDER);
        this.max_thread_count = n;
    }

    public void addComm(RecComm recComm) {
        for (int i = 0; i < this.max_thread_count; ++i) {
            CommProcThdID commProcThdID = new CommProcThdID(recComm, i);
            super.put(new Coord(0.0, commProcThdID.gthdLineID), commProcThdID);
        }
    }

    public void setCommProcThdIDUsed(Primitive primitive) {
        CommProcThdID commProcThdID = (CommProcThdID)super.get(primitive.getStartVertex());
        if (commProcThdID == null) {
            System.err.println("CommProcThdIDMap: missing CommProcThdID element with gthdLineID " + primitive.getStartVertex().lineID + "!");
        }
        commProcThdID.setUsed(true);
        if (primitive.getCategory().getTopology().isArrow()) {
            commProcThdID = (CommProcThdID)super.get(primitive.getFinalVertex());
            if (commProcThdID == null) {
                System.err.println("CommProcThdIDMap: missing CommProcThdID element with gthdLineID " + primitive.getFinalVertex().lineID + "!");
            }
            commProcThdID.setUsed(true);
        }
    }

    public void initialize() {
    }

    public void finish() {
        Iterator iterator = super.values().iterator();
        while (iterator.hasNext()) {
            CommProcThdID commProcThdID = (CommProcThdID)iterator.next();
            if (commProcThdID.isUsed()) continue;
            iterator.remove();
        }
    }

    public List createYCoordMapList() {
        ArrayList<YCoordMap> arrayList = new ArrayList<YCoordMap>(2);
        int n = super.size();
        if (this.max_thread_count > 1) {
            int n2 = 3;
            int n3 = 0;
            int[] nArray = new int[n * n2];
            int n4 = 4;
            int n5 = 0;
            int[] nArray2 = new int[n * n4];
            Iterator iterator = super.values().iterator();
            while (iterator.hasNext()) {
                CommProcThdID commProcThdID = (CommProcThdID)iterator.next();
                nArray[n3++] = commProcThdID.gthdLineID;
                nArray[n3++] = commProcThdID.wrank;
                nArray[n3++] = commProcThdID.thd;
                nArray2[n5++] = commProcThdID.gthdLineID;
                nArray2[n5++] = commProcThdID.icomm;
                nArray2[n5++] = commProcThdID.rank;
                nArray2[n5++] = commProcThdID.thd;
            }
            String[] stringArray = new String[]{"world_rank", "thread"};
            YCoordMap yCoordMap = new YCoordMap(n, n2, "Process-Thread View", stringArray, nArray, null);
            arrayList.add(yCoordMap);
            stringArray = new String[]{"commID", "comm_rank", "thread"};
            YCoordMap yCoordMap2 = new YCoordMap(n, n4, "Communicator-Thread View", stringArray, nArray2, null);
            arrayList.add(yCoordMap2);
        } else {
            int n6 = 2;
            int n7 = 0;
            int[] nArray = new int[n * n6];
            int n8 = 3;
            int n9 = 0;
            int[] nArray3 = new int[n * n8];
            Iterator iterator = super.values().iterator();
            while (iterator.hasNext()) {
                CommProcThdID commProcThdID = (CommProcThdID)iterator.next();
                nArray[n7++] = commProcThdID.gthdLineID;
                nArray[n7++] = commProcThdID.wrank;
                nArray3[n9++] = commProcThdID.gthdLineID;
                nArray3[n9++] = commProcThdID.icomm;
                nArray3[n9++] = commProcThdID.rank;
            }
            String[] stringArray = new String[]{"world_rank"};
            YCoordMap yCoordMap = new YCoordMap(n, n6, "Process View", stringArray, nArray, null);
            arrayList.add(yCoordMap);
            stringArray = new String[]{"commID", "comm_rank"};
            YCoordMap yCoordMap3 = new YCoordMap(n, n8, "Communicator View", stringArray, nArray3, null);
            arrayList.add(yCoordMap3);
        }
        return arrayList;
    }
}

