/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef YumLogView_H_Included
#define YumLogView_H_Included

#include <qthread.h>
#include <qmutex.h>

#include <ktextedit.h>


class YumLogView : public KTextEdit, public QThread
  {
    Q_OBJECT

    private:
      bool          m_bExitRequested;
      QMutex        m_mutex;
      
    private:
      void          updateContents(QString strLogFile);
      
    public:
                    YumLogView  (QWidget * pParent);
      virtual     ~ YumLogView  ();

      bool          startThread ();
      void          stopThread  () { m_bExitRequested = true; }
      
      virtual bool  event       (QEvent * pEvent);
      

    protected:
      virtual void  run();

      bool          exitRequested() const { return m_bExitRequested; }
      
    public slots:
      virtual bool  close();
  };


#endif
