/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef RepoView_H_Included
#define RepoView_H_Included

#include <klistview.h>

#include "KYumConf.h"

class OutputView;


class RepoView : public KListView
  {
    Q_OBJECT

    private:
      void          addToList       (Repo::Ptr ptrRepo, QString strFileName);
      void          redrawList      ();

    public:
                    RepoView        (QWidget * pParent);

      void          addRepo         (Repo::Ptr ptrRepo, QString strFileName);
      void          repoUpdated     (QString strTag, Repo::Ptr ptrRepo);
      void          changeItem      (QCheckListItem * pItem, Repo::Ptr ptrRepo);
      void          deleteItem      (QListViewItem * pItem);
      Repo::Ptr     getRepoAtItem   (const QListViewItem * pItem) const;

    public slots:
      void          slotReposLoaded ();
  };

#endif
