/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qapp.h>
#include <qtimer.h>

#include "UserEvents.h"
#include "Process.h"
#include "ProcessDlg.h"

class Proc : public Process
  {
    public:
      Proc(QObject * pParent) : Process(pParent) {}
      virtual ~ Proc() { qDebug("destroyed!\n"); }
  };


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

ProcessDlg::ProcessDlg(QWidget * pParent, const char * pName)

  : ThreadDlg(pParent, pName)

{
    m_pMutex    = new QMutex;
    m_pProcess  = new Proc(this);

    connect(m_pProcess, SIGNAL(processExited()),   this, SLOT(slotProcessExited()));
    connect(m_pProcess, SIGNAL(readyReadStdout()), this, SLOT(slotReadyStdout()));
    connect(m_pProcess, SIGNAL(readyReadStderr()), this, SLOT(slotReadyStderr()));
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

ProcessDlg::~ProcessDlg()
{
    delete m_pProcess;
    delete m_pMutex;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void ProcessDlg::setArgs(const QStringList & args)
{
    m_pProcess->clearArguments();
    m_pProcess->setArguments(args);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void ProcessDlg::startProcess()
{
    start();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

bool ProcessDlg::event(QEvent * pEvent)
{
    bool bProcessed = false;

    if ( pEvent->type() == QEvent::Type(c_evt_ProcessStarted) )
    {
        QMutexLocker          locker(m_pMutex);
        //ProcessStartedEvent * pEvt = dynamic_cast<ProcessStartedEvent *>(pEvent);

        slotProcessStarted();
    }

    if ( !bProcessed )
        bProcessed = ThreadDlg::event(pEvent);

    return bProcessed;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void ProcessDlg::slotProcessStarted()
{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void ProcessDlg::slotProcessExited()
{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void ProcessDlg::slotReadyStdout()
{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void ProcessDlg::slotReadyStderr()
{
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void ProcessDlg::threadMain()
{
    if ( m_pProcess->start() )
    {
        //
        // The signal launchFinished() is not emitted automatically, since we did
        // not use launch() to start the program. We use a thread-safe way to
        // inform the main thread by putting an event in its queue.
        //
        QApplication::postEvent(this, new ProcessStartedEvent(
                                               m_pProcess->processIdentifier()));

        QTimer::singleShot(15000, m_pProcess, SLOT(kill()));

        do
        {
            msleep(500);

            if ( !mayContinue() )
            {
                m_pProcess->tryTerminate();
                QTimer::singleShot(15000, m_pProcess, SLOT(kill()));
            }
        }
        while ( m_pProcess->isRunning() );
    }
}

#include "ProcessDlg.moc"
