/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qcheckbox.h>

#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>
#include <kcolorcombo.h>

#include "DlgInfo.h"
#include "KYumPreferences.h"


QString   KYumPreferences::m_strYumConfPath("/etc/yum.conf"),
          KYumPreferences::m_strLogFile("/var/log/yum.log");

QColor    KYumPreferences::c_clrInfo   (0, 0, 0),
          KYumPreferences::c_clrAddInfo(25, 174, 25),
          KYumPreferences::c_clrError  (250, 80, 0),
          KYumPreferences::c_clrPkgInfo(0, 100, 255),
          KYumPreferences::c_clrDirty  (250, 80, 0);

unsigned  KYumPreferences::m_optionFlags  = KYumPreferences::defaultOptions();
unsigned  KYumPreferences::m_disabledMsgs = 0;


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void KYumPreferences::readConfig(KConfig * pConfig)
{
    //
    // Text colors
    //
    pConfig->setGroup("TextColors");

    c_clrInfo    = pConfig->readColorEntry("normal",  &c_clrInfo);
    c_clrAddInfo = pConfig->readColorEntry("addInfo", &c_clrAddInfo);
    c_clrError   = pConfig->readColorEntry("errors",  &c_clrError);
    c_clrDirty   = pConfig->readColorEntry("dirty",   &c_clrDirty);

    //
    // Behavior
    //
    pConfig->setGroup("Behavior");

    m_optionFlags  = pConfig->readUnsignedNumEntry("flags", m_optionFlags);
    m_disabledMsgs = pConfig->readUnsignedNumEntry("messages", m_disabledMsgs);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void KYumPreferences::writeConfig(KConfig * pConfig)
{
    //
    // Text colors
    //
    pConfig->setGroup("TextColors");

    pConfig->writeEntry("normal",  c_clrInfo);
    pConfig->writeEntry("addInfo", c_clrAddInfo);
    pConfig->writeEntry("errors",  c_clrError);
    pConfig->writeEntry("dirty",   c_clrDirty);


    //
    // Behavior
    //
    pConfig->setGroup("Behavior");

    pConfig->writeEntry("flags", m_optionFlags);
    pConfig->writeEntry("messages", m_disabledMsgs);


    if ( pConfig->isReadOnly() )
        qDebug("Could not write configuration. File is read only!\n");
}


/***************************************************************************/
/**
 *  Default constructor
 *
 ***************************************************************************/

KYumPreferencesDlg::KYumPreferencesDlg()

    : KDialogBase(TreeList,
                  i18n("KYum Preferences"),
                  Help|Default|Ok|Apply|Cancel,
                  Ok)

{
    setInitialSize(configDialogSize("ConfigDlg"));
    showButton(Default, false);


    QFrame      * pFrame;
    QHBoxLayout * pHBoxLayout;

    //
    // Page "Appearance"...
    //
    pFrame = addPage(i18n("Appearance"), i18n("Appearance"));
    pHBoxLayout = new QHBoxLayout(pFrame, 0, 0);
    pHBoxLayout->setAutoAdd(true);

    m_pPageAppearance = new PrefPageAppearance(pFrame);


    //
    // Page "More Options"...
    //
    pFrame = addPage(i18n("More Options"), i18n("More Options"));
    pHBoxLayout = new QHBoxLayout(pFrame, 0, 0);
    pHBoxLayout->setAutoAdd(true);

    m_pPageBehavior = new PrefPageBehavior(pFrame);

    setMinimumSize(680, 420);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

KYumPreferencesDlg::~KYumPreferencesDlg()
{
    saveDialogSize("ConfigDlg");
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void KYumPreferencesDlg::slotOk()
{
    slotApply();
    KDialogBase::slotOk();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void KYumPreferencesDlg::slotApply()
{
    m_pPageAppearance->apply();
    m_pPageBehavior->apply();

    KConfig * pConfig = kapp->config();

    KYumPreferences::writeConfig(pConfig);
    pConfig->sync();

    KDialogBase::slotApply();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

PrefPageAppearance::PrefPageAppearance(QWidget *parent)
  : QFrame(parent)
{
    QGridLayout * pTopLayout = new QGridLayout(this,   // parent
                                               4,      // number of rows
                                               2,      // number of columns
                                               5);     // margin
    pTopLayout->setAutoAdd(true);
    pTopLayout->setColStretch(1, 1);   // only second column may grow
    pTopLayout->setRowStretch(3, 1);

    new QLabel("Normal Text:", this);
    m_pComboClrInfo = new KColorCombo(this);
    m_pComboClrInfo->setColor(KYumPreferences::c_clrInfo);

    new QLabel("Errors:", this);
    m_pComboClrError = new KColorCombo(this);
    m_pComboClrError->setColor(KYumPreferences::c_clrError);

    new QLabel("Additional Information:", this);
    m_pComboClrAddInfo = new KColorCombo(this);
    m_pComboClrAddInfo->setColor(KYumPreferences::c_clrAddInfo);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void PrefPageAppearance::apply()
{
    KYumPreferences::c_clrInfo    = m_pComboClrInfo->color();
    KYumPreferences::c_clrAddInfo = m_pComboClrAddInfo->color();
    KYumPreferences::c_clrError   = m_pComboClrError->color();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

PrefPageBehavior::PrefPageBehavior(QWidget *parent)
  : QFrame(parent)
{
    QVBoxLayout * pTopLayout = new QVBoxLayout(this, 0, 0);
    QHBoxLayout * pHBoxLayout;
    QGridLayout * pGridLayout;
    QGroupBox   * pGroupBox;
    QWidget     * pPanel;

    pTopLayout->setAutoAdd(true);

    //
    //
    //
    pPanel = new QWidget(this);
    pHBoxLayout = new QHBoxLayout(pPanel, 0, 0);
    pHBoxLayout->setAutoAdd(true);

    pGroupBox = new QGroupBox(" Install/Update ", pPanel, "groupBox1" );
    pGridLayout = new QGridLayout(pGroupBox, 1, 1, 5);
    pGridLayout->setAutoAdd(true);

    m_pCheckRemoveAfterInstall = new QCheckBox(pGroupBox, "m_pCheckRemoveAfterInstall");
    m_pCheckRemoveAfterInstall->setText(i18n("Remove packages from list after successful "
                                             "installation."));
    m_pCheckRemoveAfterInstall->setChecked(KYumPreferences::getRemoveFromListAfterInstall());

    //
    //
    //
/*
    pPanel = new QWidget(this);
    pHBoxLayout = new QHBoxLayout(pPanel, 0, 0);
    pHBoxLayout->setAutoAdd(true);

    pGroupBox = new QGroupBox(" Remove ", pPanel, "groupBox2" );
    pGridLayout = new QGridLayout(pGroupBox, 1, 1, 5);
    pGridLayout->setAutoAdd(true);

    m_pCheckAssumeYesOnRemove = new QCheckBox(pGroupBox, "m_pCheckRemoveAfterInstall");
    m_pCheckAssumeYesOnRemove->setText(i18n("Assume -y when removing installed packages "));
    m_pCheckAssumeYesOnRemove->setChecked(KYumPreferences::getAssumeYesOnRemove());
*/
    //
    //
    //
    pPanel = new QWidget(this);
    pHBoxLayout = new QHBoxLayout(pPanel, 0, 0);
    pHBoxLayout->setAutoAdd(true);

    pGroupBox = new QGroupBox(" yum.conf ", pPanel, "groupBox3" );
    pGridLayout = new QGridLayout(pGroupBox, 1, 1, 5);
    pGridLayout->setAutoAdd(true);

    m_pCheckMonitorYumConf = new QCheckBox(pGroupBox, "m_pCheckMonitorYumConf");
    m_pCheckMonitorYumConf->setText(i18n("Monitor for external modification."));
    m_pCheckMonitorYumConf->setChecked(KYumPreferences::getMonitorYumConf());

    m_pCheckConfirmSave = new QCheckBox(pGroupBox, "m_pCheckConfirmSavef");
    m_pCheckConfirmSave->setText(i18n("Show confirmation dialog when yum.conf "
                                      "and repositories have been saved."));

    KYumPreferences::setConfirmSave(DlgInfo::isMsgEnabled(DlgInfo::c_YumConfAndReposSaved));
    m_pCheckConfirmSave->setChecked(KYumPreferences::getConfirmSave());
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void PrefPageBehavior::apply()
{
    KYumPreferences::setMonitorYumConf(m_pCheckMonitorYumConf->isChecked());
    KYumPreferences::setConfirmSave(m_pCheckConfirmSave->isChecked());
    KYumPreferences::setRemoveFromListAfterInstall(m_pCheckRemoveAfterInstall->isChecked());
//    KYumPreferences::setAssumeYesOnRemove(m_pCheckAssumeYesOnRemove->isChecked());

    DlgInfo::enableMsg(DlgInfo::c_YumConfAndReposSaved, KYumPreferences::getConfirmSave());
}


#include "KYumPreferences.moc"

