/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef OrderedMap_H_Included
#define OrderedMap_H_Included


template <class Key, class Data> class FastList
  {
    private:
      typedef std::list<Key>                          List;
      typedef std::map<Key, Data>                     Map; 
      typedef std::map<Key, typename List::iterator>  Map2;
      typedef typename Map::iterator                  MapIterator;
      
    
    public:
      typedef typename List::iterator      Iterator;
    
    private:
      List            m_list;
      Map             m_map;
      Map2            m_map2;
    
  
    public:
      bool            push_back (const Key & key, const Data & data);
      void            erase     (const Key & key);
      void            erase     (const Iterator & it);
      
      Iterator        find  (const Key & key)       { return m_map2.find(key); }
      const Iterator  find  (const Key & key) const { return m_map2.find(key); }
      
      Data *          data  (const Key & key);
      const Data *    data  (const Key & key) const;
      
      
      Iterator        begin ()       { return m_list.begin(); }
      const Iterator  begin () const { return m_list.begin(); }
      
      Iterator        end   ()       { return m_list.end(); }
      const Iterator  end   () const { return m_list.end(); }
  };


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

template <class Key, class Data>

bool FastList<Key, Data>::push_back(const Key & key, const Data & data)
{
    bool              bSuccess = false;
    const MapIterator it       = m_map.find(key);
    
    if ( it == m_map.end() )
    {
        m_map[key] = data;
        m_list.push_back(key);
        m_map2[key] = m_list.last();
        
        bSuccess = true;
    }
    
    return bSuccess;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

template <class Key, class Data>

void FastList<Key, Data>::erase(const Iterator & it)
{
    m_map.erase(*it);
    m_map2.erase(*it);
    m_list.erase(it);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

template <class Key, class Data>

void FastList<Key, Data>::erase(const Key & key)
{
    const MapIterator it = m_map.find(key);
    
    if ( it != m_map.end() )
        erase(it);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

template <class Key, class Data>

const Data * FastList<Key, Data>::data(const Key & key) const
{
    return (const Data *) ((FastList<Key, Data> *) this)->data(key);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

template <class Key, class Data>

Data * FastList<Key, Data>::data(const Key & key)
{
    MapIterator   it    = m_map.find(key);
    Data *        pData = 0;
    
    if ( it != m_map.end() )
        pData = &it->second;
    
    return pData;
}


#endif
