/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef DlgImportGPG_H_Included
#define DlgImportGPG_H_Included

#include <qthread.h>
#include <qmutex.h>

#include "BaseDlgImportGPG.h"


class QProcess;


//
//
//
class DlgImportGPG : public BaseDlgImportGPG, public QThread
  {
    Q_OBJECT

    private:
      QString       m_strKey;
      bool          m_bThreadDone,
                    m_bExitRequested;
      QProcess *    m_pProcess;
      QMutex        m_mutex;

    public:
                    DlgImportGPG(QWidget * pParent, QString strKey);

      QString       getKey() const { return m_strKey; }

    protected slots:
      virtual bool  event               (QEvent * pEvent);
      virtual void  accept              ();
      virtual void  reject              ();
      virtual void  slotKeyChanged      (const QString &);

      virtual void  slotProcessStarted  ();
      virtual void  slotProcessExited   ();
      virtual void  slotReadyStdout     ();
      virtual void  slotReadyStderr     ();

    protected:
      virtual void  run();
  };

#endif
