#!/bin/python

import sys, rpm
import rpmUtils.transaction
import rpmUtils.arch

#
# This is taken from yum (and slightly modified)
#
def _getsysver(distroVerPkg):
    ts = rpmUtils.transaction.initReadOnlyTransaction(root='/')
    ts.pushVSFlags(~(rpm._RPMVSF_NOSIGNATURES|rpm._RPMVSF_NODIGESTS))
    idx = ts.dbMatch('provides', distroVerPkg)
    # we're going to take the first one - if there is more than one of these
    # then the user needs a beating
    if idx.count() == 0:
        releasever = 'Null'
    else:
        hdr = idx.next()
        releasever = hdr['version']
        del hdr
    del idx
    del ts
    return releasever


baseArch = rpmUtils.arch.getBaseArch()
arch     = rpmUtils.arch.getCanonArch()
releasever = _getsysver(sys.argv[1])
    
print baseArch, ';', arch, ';', releasever
sys.exit(0)    
