/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kstartsupplicantdlg.h"
#include "wlanlib.h"
#include "wpa_ctrl.h"
#include "kwlansuclient.h"

#include <qstringlist.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qstring.h>
#include <kmessagebox.h>
#include <qwidget.h>
#include <klocale.h>

KStartSupplicantDlg::KStartSupplicantDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KStartSupplicant(parent,name, modal,fl)
{
    cbDriver->clear();
    cbDriver->insertItem("atmel");
    cbDriver->insertItem("broadcom");
    cbDriver->insertItem("bsd");
    cbDriver->insertItem("hostap");
    cbDriver->insertItem("ipw");
    cbDriver->insertItem("madwifi");
    cbDriver->insertItem("ndiswrapper");
    cbDriver->insertItem("prism54");
    cbDriver->insertItem("wext");
    cbDriver->insertItem("wired");
}

KStartSupplicantDlg::~KStartSupplicantDlg()
{
}

/*$SPECIALIZATION$*/
void KStartSupplicantDlg::setData(QString *interface, QString *driver)
{
    if (interface) txtInterface->setText(*interface);
    if (driver) cbDriver->setCurrentText(*driver);
}

void KStartSupplicantDlg::Cancel()
{
    m_start = FALSE;
    QWidget::close(false);
}

QString KStartSupplicantDlg::getInterface()
{
    return txtInterface->text();
}

QString KStartSupplicantDlg::getDriver()
{
    return cbDriver->currentText();
}

void KStartSupplicantDlg::startSupplicant()
{
    struct wpa_ctrl;
    // First get parameters
    QString interface, driver;
    interface = txtInterface->text();
    driver = cbDriver->currentText();

    if ((!interface.isEmpty()) && (!driver.isEmpty())) {
        m_start=TRUE;
        QWidget::close(false);
    }
    else {
        KMessageBox::sorry(this,i18n("You must select a driver an interface."));
    }
}



#include "kstartsupplicantdlg.moc"


