
#==============================================================================#
# $Id: axis_minor_grid.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/axis_minor_grid.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'

#==============================================================================#

module GRb

  module Chart

    class AxisMinorGridDecorator < NoChildDecoratorBase

      def initialize
        @number = nil
        @color  = nil
      end

      attr_accessor :number, :color

      def draw(image, box)
        width = (box.dx - 1).to_f / @number.to_f
        start = box.x + width / 2.0

        number.times { |i|
          x = (start + width * i).ceil
          image.line(x, box.y, x, box.y2, @color)
        }
      end

    end # AxisMinorGridDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::AxisMinorGrid.new.instance_eval {
      self.number = 10
      self.color  = GRb::Color.red(128)
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
