
#==============================================================================#
# $Id: facade.rb,v 1.2 2004/01/23 00:38:04 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/pie_base/facade.rb,v $
#==============================================================================#

require 'grb/chart/base/facade'
require 'grb/chart/base/parts/legend'

#==============================================================================#

module GRb

  module Chart

    class PieChartFacadeBase < ChartFacadeBase

      def create_legend(property)
        font   = property.font.create_font
        legend = Legend.new(property)

        @data.each { |item|
          legend.add(font, item[:name], Legend::Marker::Color.new(item[:color], @property_chart.edge.color))
        }

        return legend
      end
      protected :create_legend

      def create_chart(property)
        graph = self.create_chart2(property)

        @data.each { |item|
          graph.add_value(item[:name], item[:value], item[:color])
        }

        return graph
      end
      protected :create_chart

    end # PieChartFacadeBase

  end # Graph

end # GRb

#==============================================================================#
#==============================================================================#
