
#==============================================================================#
# $Id: font.rb,v 1.2 2004/01/23 04:41:17 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/utility/font.rb,v $
#==============================================================================#

module GRb

  module Chart

    class Font

      Giant  = 'Giant'
      Large  = 'Large'
      Medium = 'Medium'
      Small  = 'Small'
      Tiny   = 'Tiny'

      def initialize(font, color = GRb::Color.black, angle = 0)
        @font  = font
        @color = color
        @angle = angle
      end

      attr_reader :font

      def self.gd(name, bold = false, italic = false, color = GRb::Color.black, vertical = false)
        return self.new(GRb::Font.gd(name, bold, italic), color, (vertical ? 90 : 0))
      end

      def self.truetype(filepath, size = 12, color = GRb::Color.black, angle = 0)
        return self.new(GRb::Font.truetype(filepath, size), color, angle)
      end

      def draw(image, x, y, text, align = GRb::Font::ALIGN_LEFT, valign = GRb::Font::VALIGN_TOP)
        image.string(@font, x, y, @angle, @color, text, align, valign)
      end

      def bound(text)
        return @font.bound(text, @angle)
      end

      def width(text)
        return @font.width(text, @angle)
      end

      def height(text)
        return @font.height(text, @angle)
      end

    end # Font

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  GRb::Image.create_and_write_png_file(400, 400, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    image.line(0, 100, 400, 100, GRb::Color.red(128))
    image.line(0, 300, 400, 300, GRb::Color.red(128))
    image.line(200, 0, 200, 400, GRb::Color.red(128))

    text = 'AaBbCc'

    gd = GRb::Chart::Font.gd(GRb::Chart::Font::Giant, false, false, GRb::Color.green(128))
    tt = GRb::Chart::Font.truetype('/cygdrive/c/WINDOWS/Fonts/CENTURY.TTF', 16, GRb::Color.blue(128))

    gd.draw(image, 200, 125, text, GRb::Font::ALIGN_LEFT,   GRb::Font::VALIGN_MIDDLE)
    gd.draw(image, 200, 150, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_MIDDLE)
    gd.draw(image, 200, 175, text, GRb::Font::ALIGN_RIGHT,  GRb::Font::VALIGN_MIDDLE)

    tt.draw(image, 200, 200, text, GRb::Font::ALIGN_LEFT,   GRb::Font::VALIGN_MIDDLE)
    tt.draw(image, 200, 225, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_MIDDLE)
    tt.draw(image, 200, 250, text, GRb::Font::ALIGN_RIGHT,  GRb::Font::VALIGN_MIDDLE)

    gd.draw(image, 100, 100, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_TOP)
    gd.draw(image, 200, 100, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_MIDDLE)
    gd.draw(image, 300, 100, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_BOTTOM)

    tt.draw(image, 100, 300, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_TOP)
    tt.draw(image, 200, 300, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_MIDDLE)
    tt.draw(image, 300, 300, text, GRb::Font::ALIGN_CENTER, GRb::Font::VALIGN_BOTTOM)
  }
end

#==============================================================================#
#==============================================================================#
