
#==============================================================================#
# $Id: shadow.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/shadow.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/decorator/shadow'

#==============================================================================#

module GRb

  module Chart

    class ShadowProperty < PropertyBase

      def initialize
        @visible  = nil
        @color    = nil
        @offset_x = nil
        @offset_y = nil
      end

      attr_accessor :visible, :color, :offset_x, :offset_y

      def create_decorator(child)
        if @visible
          decorator = ShadowDecorator.new(child)
          decorator.color    = @color    || GRb::Color.gray(128)
          decorator.offset_x = @offset_x || 2
          decorator.offset_y = @offset_y || 2
          return decorator
        else
          return child
        end
      end

    end # ShadowProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
