#! /usr/bin/ruby -Ke

#==============================================================================#
# $Id: pie3.rb,v 1.3 2004/01/23 00:38:36 yuya Exp $
#==============================================================================#

require 'grb/chart/pie/facade'

#==============================================================================#

data = [
  {:name => 'Field 1', :value => 9, :color => GRb::Color.red(224)    },
  {:name => 'Field 2', :value => 8, :color => GRb::Color.green(224)  },
  {:name => 'Field 3', :value => 6, :color => GRb::Color.blue(224)   },
  {:name => 'Field 4', :value => 5, :color => GRb::Color.yellow(224) },
  {:name => 'Field 5', :value => 3, :color => GRb::Color.skyblue(224)},
  {:name => 'Field 6', :value => 2, :color => GRb::Color.purple(224) },
]

#==============================================================================#

facade = GRb::Chart::PieChartFacade.create(400, 300, true)
facade.title.text                   = 'Pie Chart Sample 3'          # ȥ ʸ
facade.title.font.color             = GRb::Color.white              # ȥ ե 
facade.frame.gradation.visible      = true                          # ط ǡ ɽ
facade.frame.gradation.start_color  = GRb::Color.new(0, 0, 64)      # ط ǡ Ͽ
facade.frame.gradation.end_color    = GRb::Color.new(0, 128, 255)   # ط ǡ λ
facade.legend.vertical              = false                         #  ʿ
facade.legend.position              = :bottom_center                #  
facade.legend.border.visible        = false                         #   ɽ
facade.legend.gradation.visible     = true                          #  ǡ ɽ
facade.legend.gradation.start_color = GRb::Color.new(128, 192, 255) #  ǡ Ͽ
facade.legend.gradation.end_color   = GRb::Color.new(192, 255, 255) #  ǡ λ
facade.legend.gradation.angle       = 90                            #  ǡ 
facade.data                         = data
facade.write_png_file('pie3.png')

#==============================================================================#
#==============================================================================#
